/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.clike.CatchExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Check(id="cqse-catch-high-level-exception", languages={ELanguage.JAVA, ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CatchHighLevelExceptionCheck
extends CatchExceptionCheckBase {
    protected String getFindingMessage(Optional<String> className) {
        return className.map(s -> "Catch clause catches generic exception `" + s + "`").orElse("Catch clause catches anonymous exception");
    }

    protected boolean createFindingForException(Optional<String> className, ShallowEntity entity) {
        if (className.isEmpty()) {
            return true;
        }
        return switch (this.context.getLanguage()) {
            case ELanguage.JAVA -> LanguageFeatureParser.JAVA.isGenericExceptionClass(className.get());
            case ELanguage.CS -> {
                if (LanguageFeatureParser.CS.isGenericExceptionClass(className.get()) && !TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.WHEN)) {
                    yield true;
                }
                yield false;
            }
            default -> {
                CCSMAssert.fail((String)"Expected only Java or C# as input language");
                yield false;
            }
        };
    }
}

