/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-clike-avoid-if-true", languages={ELanguage.JAVA, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.OPEN_CL, ELanguage.JAVASCRIPT, ELanguage.XTEND, ELanguage.SWIFT, ELanguage.GROOVY, ELanguage.GOSU, ELanguage.KOTLIN, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ClikeAvoidIfTrueCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"if".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() >= 4) {
            IToken firstConditionToken = (IToken)tokens.get(2);
            ETokenType firstConditionTokenType = firstConditionToken.getType();
            ETokenType secondConditionTokenType = ((IToken)tokens.get(3)).getType();
            if (firstConditionTokenType == ETokenType.BOOLEAN_LITERAL && firstConditionToken.getText().equals("true") && (secondConditionTokenType == ETokenType.RPAREN || secondConditionTokenType == ETokenType.ANDAND || secondConditionTokenType == ETokenType.OROR)) {
                this.buildFinding("Conditional expressions of the form `if (true...` should be avoided", this.buildLocation().forLine(entity.getStartLine())).createAndStore();
            }
        }
    }
}

