/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.clike.ConditionalStatementsEqualCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.clike.ConditionalBlock;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.Collections;
import java.util.List;

@Check(id="cqse-conditional-statements-equal", languages={ELanguage.JAVA, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OPEN_CL, ELanguage.JAVASCRIPT, ELanguage.XTEND, ELanguage.GROOVY, ELanguage.GOSU, ELanguage.KOTLIN, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ConditionalStatementsEqualCheck
extends ConditionalStatementsEqualCheckBase {
    public static final String NAME = "Statements in Conditional Expression are equal";
    @CheckOption(name="Statements in Conditional Expression are equal: Use character equality.", description="If enabled, character equality is used to compare the statements within the conditional branches; findings are created only if the statements are exactly the same on the character level. If disabled, the statements within the conditional branches are compared on the token level, i.e., findings are created for conditional branches that are likely to be similar in meaning, but differ in their concrete text contents.")
    private boolean useCharacterEquality = true;
    private List<IToken> preprocessedTokens;

    @Override
    protected boolean useCharacterEquality() {
        return this.useCharacterEquality;
    }

    @Override
    protected void prepareBlockGroupsProcessing() throws CheckException {
        this.preprocessedTokens = PreprocessorUtils.hasPreprocessor((ELanguage)this.context.getLanguage()) ? ((ShallowEntity)this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED).get(0)).getAllTokensOfFile().stream().filter(token -> !TokenUtils.isCommentToken((IToken)token)).toList() : Collections.emptyList();
    }

    @Override
    protected boolean shouldSkipBlock(ConditionalBlock block, List<IToken> slocTokens, int sloc) {
        return false;
    }

    @Override
    protected int hashBlockContent(ConditionalBlock block) throws CheckException {
        if (PreprocessorUtils.hasPreprocessor((ELanguage)this.context.getLanguage())) {
            return this.hashBlockContentForPreprocessedLanguages(block);
        }
        return this.hashBlockContentForUnpreprocessedLanguages(block);
    }

    private int hashBlockContentForPreprocessedLanguages(ConditionalBlock block) throws CheckException {
        List<IToken> unPreprocessedContent = this.getUnPreprocessedTokens(block);
        if (this.useCharacterEquality()) {
            return TokenStreamTextUtils.concatTokenTexts(unPreprocessedContent).hashCode();
        }
        return unPreprocessedContent.stream().map(IToken::getType).toList().hashCode();
    }

    protected List<IToken> getUnPreprocessedTokens(ConditionalBlock block) throws CheckException {
        int preprocessedTokenIndexBeforeBlock = ((ShallowEntity)block.getContent().get(0)).getStartTokenIndex();
        int preprocessedTokenIndexAfterBlock = ((ShallowEntity)block.getContent().getLast()).getEndTokenIndex();
        List unPreprocessedTokens = this.context.getTokens(ECodeViewOption.FILTERED);
        return PreprocessedTokenStreamUtils.mapTokensToUnpreprocessed((int)preprocessedTokenIndexBeforeBlock, (int)preprocessedTokenIndexAfterBlock, this.preprocessedTokens, (List)unPreprocessedTokens);
    }
}

