/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.EntitySelectionPredicates;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

@Check(id="cqse-deprecated-annotation", languages={ELanguage.JAVA, ELanguage.KOTLIN}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DeprecatedAnnotationCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List entities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.TYPE, EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity entity : entities) {
            this.processEntity(entity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (EntitySelectionPredicates.annotated((String)"Deprecated").test(entity)) {
            String entityType = "Field";
            if (entity.getType() == EShallowEntityType.TYPE) {
                entityType = "Type";
            } else if (entity.getType() == EShallowEntityType.METHOD) {
                entityType = "Method";
            }
            String message = entityType + " `" + entity.getName() + "` is marked as `@Deprecated`";
            this.buildFinding(message, this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

