/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.util.TernaryOperatorCheckUtil;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.enums.EnumUtils;

@Check(id="cqse-dont-use-ternary-operator", languages={ELanguage.JAVASCRIPT, ELanguage.JAVA, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DontUseTernaryOperatorCheck
extends CheckImplementationBase {
    private static final String CHECK_OPTION_NAME_MULTILINE = "Allow single-line non-nested ternary expressions";
    private static final String CHECK_OPTION_DESCRIPTION_MULTILINE = "If activated the check doesn't create findings when the ternary expression is a single line.\nSome simple ternary expressions are better written in multiple lines, e.g., due to long variable names.\n";
    private static final String CHECK_OPTION_NAME_SIMPLE = "Allow non-nested simple ternary operators";
    private static final String CHECK_OPTION_DESCRIPTION_SIMPLE = "Ternary operators are permitted for simple assignments, null checks that lead to initialization, and non-nested expressions. Method calls are allowed only when preceded by a null check. Examples:\n1.a) No finding: var foo = bar.isEmpty() ? 0 : bar.baz;\n1.b) Finding: var foo = bar.isEmpty() ? 0 : bar.baz();\n2.a) No finding: return foo == null ? 0 : foo.bar();\n2.b) No finding: return foo.bar.baz == null ? 0 : foo.bar(\"baz\");\n2.c) Finding: return foo == null ? 0 : bar();\n2.d) Finding: return foo.bar.baz == null ? 0 : foo.bar.init(baz);\n3.a) No finding: foo = bar.getType() == \"string\" ? \"42\" : 42;\n3.b) Finding: foo = type(bar) == \"string\" ? \"42\" : 42;\n4.b) No finding: var foo = bar.isEmpty() ? 0 : bar;\n4.b) Finding: var foo = bar.isEmpty() ? 0 : bar.size();";
    @CheckOption(name="Allow single-line non-nested ternary expressions", description="If activated the check doesn't create findings when the ternary expression is a single line.\nSome simple ternary expressions are better written in multiple lines, e.g., due to long variable names.\n")
    private boolean allowOnlySingleLineTernaryExpressions = true;
    @CheckOption(name="Allow non-nested simple ternary operators", description="Ternary operators are permitted for simple assignments, null checks that lead to initialization, and non-nested expressions. Method calls are allowed only when preceded by a null check. Examples:\n1.a) No finding: var foo = bar.isEmpty() ? 0 : bar.baz;\n1.b) Finding: var foo = bar.isEmpty() ? 0 : bar.baz();\n2.a) No finding: return foo == null ? 0 : foo.bar();\n2.b) No finding: return foo.bar.baz == null ? 0 : foo.bar(\"baz\");\n2.c) Finding: return foo == null ? 0 : bar();\n2.d) Finding: return foo.bar.baz == null ? 0 : foo.bar.init(baz);\n3.a) No finding: foo = bar.getType() == \"string\" ? \"42\" : 42;\n3.b) Finding: foo = type(bar) == \"string\" ? \"42\" : 42;\n4.b) No finding: var foo = bar.isEmpty() ? 0 : bar;\n4.b) Finding: var foo = bar.isEmpty() ? 0 : bar.size();")
    private boolean allowSimpleTernaryOperator = true;
    private static final int METHOD_TOKEN_PATTERN_GROUP = 0;
    private static final int NULL_CHECK_TOKEN_PATTERN_GROUP = 1;
    private static final EnumSet<ETokenType> PRIMITIVE_LITERALS = EnumSet.of(ETokenType.BOOLEAN_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.CHARACTER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.STRING_LITERAL);
    private static final EnumSet<ETokenType> PRIMITIVE_LITERALS_AND_NULL = EnumUtils.mergeSets(PRIMITIVE_LITERALS, (Enum[])new ETokenType[]{ETokenType.NULL_LITERAL});
    private static final EnumSet<ETokenType> COMPARISON_OPERATORS = EnumSet.of(ETokenType.NOTEQ, new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQEQ, ETokenType.EQEQEQ, ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ});
    private static final EnumSet<ETokenType> EQUAL_AND_NOTEQUAL_OPERATORS = EnumSet.of(ETokenType.NOTEQ, ETokenType.EQEQ, ETokenType.NOTEQEQ, ETokenType.EQEQEQ);
    private static final EnumSet<ETokenType> IDENTIFIER_TYPES = EnumSet.of(ETokenType.VAR, new ETokenType[]{ETokenType.LET, ETokenType.CONST, ETokenType.BYTE, ETokenType.CHAR, ETokenType.SHORT, ETokenType.INT, ETokenType.LONG, ETokenType.FLOAT, ETokenType.DOUBLE, ETokenType.BOOLEAN, ETokenType.WCHAR_T, ETokenType.BOOL, ETokenType.SBYTE, ETokenType.DECIMAL, ETokenType.UINT, ETokenType.ULONG, ETokenType.USHORT, ETokenType.IDENTIFIER});
    private static final TokenPattern IDENTIFIER_PATTERN = new TokenPattern().optional(new Object[]{ETokenType.THIS, ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).notFollowedBy((Object)ETokenType.DOT).notFollowedBy((Object)ETokenType.LPAREN).optional(new Object[]{ETokenType.NOT});
    private static final TokenPattern METHOD_CALL_PATTERN = new TokenPattern().optional(new Object[]{ETokenType.THIS, ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).notFollowedBy((Object)ETokenType.DOT).sequence(new Object[]{ETokenType.LPAREN}).skipTo(new Object[]{ETokenType.RPAREN}).notFollowedBy((Object)ETokenType.DOT);
    private static final TokenPattern CHECK_IN_PATTERN = new TokenPattern().alternative(new Object[]{ETokenType.IDENTIFIER, PRIMITIVE_LITERALS}).sequence(new Object[]{ETokenType.IN, IDENTIFIER_PATTERN});
    private static final TokenPattern COMPARISON_PATTERN = new TokenPattern().alternative(new Object[]{IDENTIFIER_PATTERN, PRIMITIVE_LITERALS}).alternative(new Object[]{COMPARISON_OPERATORS}).alternative(new Object[]{IDENTIFIER_PATTERN, PRIMITIVE_LITERALS});
    private static final TokenPattern NULL_CHECK_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{IDENTIFIER_PATTERN}).group(1).alternative(new Object[]{EQUAL_AND_NOTEQUAL_OPERATORS}).sequence(new Object[]{ETokenType.NULL_LITERAL}), new TokenPattern().sequence(new Object[]{ETokenType.NULL_LITERAL}).alternative(new Object[]{EQUAL_AND_NOTEQUAL_OPERATORS}).sequence(new Object[]{IDENTIFIER_PATTERN}).group(1)});
    private static final TokenPattern LEFT_SIDE_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().alternative(new Object[]{IDENTIFIER_TYPES}).optional(new Object[]{ETokenType.LBRACK, ETokenType.RBRACK}).sequence(new Object[]{IDENTIFIER_PATTERN}).sequence(new Object[]{ETokenType.EQ}), new TokenPattern().optional(new Object[]{new TokenPattern().optional(new Object[]{ETokenType.SIGNED}), new TokenPattern().optional(new Object[]{ETokenType.UNSIGNED})}).repeated(new Object[]{new TokenPattern().alternative(new Object[]{ETokenType.SHORT, ETokenType.LONG})}).alternative(new Object[]{IDENTIFIER_TYPES}).sequence(new Object[]{IDENTIFIER_PATTERN}).sequence(new Object[]{ETokenType.EQ}), new TokenPattern().optional(new Object[]{new TokenPattern().optional(new Object[]{ETokenType.SIGNED}), new TokenPattern().optional(new Object[]{ETokenType.UNSIGNED})}).alternative(new Object[]{IDENTIFIER_TYPES}).sequence(new Object[]{IDENTIFIER_PATTERN}).sequence(new Object[]{ETokenType.EQ}), new TokenPattern().sequence(new Object[]{IDENTIFIER_PATTERN}).sequence(new Object[]{ETokenType.EQ}), new TokenPattern().sequence(new Object[]{ETokenType.RETURN}), new TokenPattern()}).alternative(new Object[]{METHOD_CALL_PATTERN, COMPARISON_PATTERN, NULL_CHECK_PATTERN, IDENTIFIER_PATTERN, CHECK_IN_PATTERN});
    private static final TokenPattern RIGHT_SIDE_SIMPLE_PATTERN = new TokenPattern().alternative(new Object[]{PRIMITIVE_LITERALS, IDENTIFIER_PATTERN, ETokenType.NULL_LITERAL}).sequence(new Object[]{ETokenType.COLON}).alternative(new Object[]{PRIMITIVE_LITERALS, IDENTIFIER_PATTERN, ETokenType.NULL_LITERAL});
    private static final TokenPattern RIGHT_SIDE_WITH_METHOD_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().alternative(new Object[]{METHOD_CALL_PATTERN, IDENTIFIER_PATTERN}).group(0).sequence(new Object[]{ETokenType.COLON}).alternative(new Object[]{PRIMITIVE_LITERALS_AND_NULL}), new TokenPattern().alternative(new Object[]{PRIMITIVE_LITERALS_AND_NULL}).sequence(new Object[]{ETokenType.COLON}).alternative(new Object[]{METHOD_CALL_PATTERN, IDENTIFIER_PATTERN}).group(0)});

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity statement) {
        boolean isOneLiner;
        List ternaryIndices = TernaryOperatorCheckUtil.findOccurrences((ShallowEntity)statement);
        if (ternaryIndices.isEmpty()) {
            return;
        }
        if (ternaryIndices.size() > 1) {
            this.createFindingForTokens((List<IToken>)statement.includedTokens());
            return;
        }
        int ternaryIndex = (Integer)ternaryIndices.get(0);
        UnmodifiableList tokens = statement.ownStartTokens();
        List<IToken> leftSideTokens = DontUseTernaryOperatorCheck.getLeftSideTokens((List<IToken>)tokens, ternaryIndex);
        List<IToken> rightSideTokens = DontUseTernaryOperatorCheck.getRightSideTokens((List<IToken>)tokens, ternaryIndex);
        boolean bl = isOneLiner = leftSideTokens.get(0).getLineNumber() == rightSideTokens.get(rightSideTokens.size() - 1).getLineNumber();
        if (this.allowOnlySingleLineTernaryExpressions && isOneLiner) {
            return;
        }
        if (this.allowSimpleTernaryOperator) {
            this.matchToRules(ternaryIndex, (List<IToken>)tokens, leftSideTokens, rightSideTokens);
        } else {
            this.createFindingForTokens(List.of((IToken)tokens.get(ternaryIndex)));
        }
    }

    private static List<IToken> getRightSideTokens(List<IToken> tokens, int ternaryIndex) {
        List<IToken> rightSideTokens = tokens.subList(ternaryIndex + 1, tokens.size());
        return (List)TokenStreamUtils.splitWithNesting(rightSideTokens, (ETokenType)ETokenType.COMMA, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN).get(0);
    }

    private static List<IToken> getLeftSideTokens(List<IToken> tokens, int ternaryIndex) {
        List<IToken> leftSideTokens = tokens.subList(0, ternaryIndex);
        int openParenthesisCount = 0;
        int unclosedParenthesisIndex = -1;
        for (int i = leftSideTokens.size() - 1; i >= 0; --i) {
            IToken token = leftSideTokens.get(i);
            if (ETokenType.RPAREN == token.getType()) {
                ++openParenthesisCount;
                continue;
            }
            if (ETokenType.LPAREN != token.getType()) continue;
            if (openParenthesisCount == 0) {
                unclosedParenthesisIndex = i;
                break;
            }
            --openParenthesisCount;
        }
        List<IToken> tokenSinceLastUnclosedParenthesis = leftSideTokens.subList(unclosedParenthesisIndex + 1, leftSideTokens.size());
        List splitTokens = TokenStreamUtils.splitWithNesting(tokenSinceLastUnclosedParenthesis, (ETokenType)ETokenType.COMMA, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        return (List)splitTokens.get(splitTokens.size() - 1);
    }

    private void createFindingForTokens(List<IToken> tokens) {
        if (CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES.contains(this.context.getLanguage()) && tokens.stream().allMatch(PreprocessedTokenStreamUtils::isTokenMacroExpanded)) {
            return;
        }
        this.buildFinding("Avoid using ternary operators", this.buildLocation().forTokens(tokens)).createAndStore();
    }

    private void matchToRules(int ternaryIndex, List<IToken> tokens, List<IToken> leftSideTokens, List<IToken> rightSideTokens) {
        TokenPatternMatch leftSideMatch = LEFT_SIDE_PATTERN.matchAtStartOf(leftSideTokens);
        TokenPatternMatch rightSideSimpleMatch = RIGHT_SIDE_SIMPLE_PATTERN.matchAtStartOf(rightSideTokens);
        if (leftSideMatch != null && rightSideSimpleMatch != null) {
            return;
        }
        if (leftSideMatch == null) {
            this.createFindingForTokens(List.of(tokens.get(ternaryIndex)));
            return;
        }
        TokenPatternMatch rightSideWithMethodMatch = RIGHT_SIDE_WITH_METHOD_PATTERN.matchAtStartOf(rightSideTokens);
        if (leftSideMatch.hasGroup(1)) {
            if (leftSideMatch.getMatchGroup(1).isEmpty() || !DontUseTernaryOperatorCheck.isFullyMatched(rightSideWithMethodMatch) || !DontUseTernaryOperatorCheck.isInitializedAfterNullCheck(leftSideMatch, rightSideWithMethodMatch)) {
                this.createFindingForTokens(List.of(tokens.get(ternaryIndex)));
            }
        } else {
            this.createFindingForTokens(List.of(tokens.get(ternaryIndex)));
        }
    }

    private static boolean isInitializedAfterNullCheck(TokenPatternMatch leftSide, TokenPatternMatch rightSide) {
        String leftSideText = ((MatchGroupElement)leftSide.getMatchGroup(1).get(0)).concatTokenTexts();
        String rightSideText = ((MatchGroupElement)rightSide.getMatchGroup(0).get(0)).concatTokenTexts();
        return leftSideText.contains(rightSideText = rightSideText.split("\\(")[0]) || rightSideText.contains(leftSideText);
    }

    private static boolean isFullyMatched(TokenPatternMatch match) {
        return match != null && match.hasGroup(0) && !match.getMatchGroup(0).isEmpty();
    }
}

