/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Check(id="cqse-long-string", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class LongStringCheck
extends CheckImplementationBase {
    @VisibleForTesting
    static final String MACRO_OR_FUNCTION_NAME_FINDING_PROPERTY_NAME = "Macro or Function Name";
    @VisibleForTesting
    static final String CHAR_LENGTH_FINDING_PROPERTY_NAME = "Char Length";
    @CheckOption(name="Maximum String Length", description="The maximum string length allowed.")
    private int maxStringLength = 40;
    @CheckOption(name="Function/Macro Names", description="Comma-separated list of function/macro names. If this field is used, Teamscale will look for string parameters only in calls for the listed functions/macros. We consider only macro names called in the original source code, not intermediary macros evaluated inside other macros. If left empty, all string parameters in all functions/macro calls and outside of function calls will be checked.")
    private Set<Object> consideredFunctionAndMacroNames = Collections.emptySet();

    public void execute() throws CheckException {
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE))) {
            UnmodifiableList tokens = entity.includedTokens();
            int longestLiteralIndex = this.findLongestLiteralIndex(entity);
            if (-1 == longestLiteralIndex) continue;
            IToken longLiteral = (IToken)tokens.get(longestLiteralIndex);
            String macroOrFunctionName = this.determineCalledFunctionOrMacroName((List<IToken>)tokens, longestLiteralIndex);
            if (!this.consideredFunctionAndMacroNames.isEmpty() && !this.consideredFunctionAndMacroNames.contains(macroOrFunctionName)) continue;
            String literalText = LongStringCheck.determineTextForAdjacentString(longestLiteralIndex, (List<IToken>)tokens);
            FindingPropertyList properties = new FindingPropertyList();
            properties.addProperty(MACRO_OR_FUNCTION_NAME_FINDING_PROPERTY_NAME, (Object)macroOrFunctionName);
            properties.addProperty(CHAR_LENGTH_FINDING_PROPERTY_NAME, (Object)literalText.length());
            IToken targetToken = this.determineFindingTargetToken(longLiteral);
            this.buildFinding(this.buildFindingMessage(literalText), this.buildLocation().forToken(targetToken)).addFindingProperties(properties).createAndStore();
        }
    }

    private static int findCalledMacroTokenInCodeBeforePreprocessing(IToken preprocessorGeneratedToken, List<IToken> tokensBeforePreprocessing) {
        return TokenStreamUtils.indexOfByOffset(tokensBeforePreprocessing, (int)preprocessorGeneratedToken.getOffset());
    }

    private String determineCalledFunctionOrMacroName(List<IToken> tokens, int longestLiteralIndex) throws CheckException {
        IToken longLiteral = tokens.get(longestLiteralIndex);
        if (PreprocessedTokenStreamUtils.isTokenMacroExpanded((IToken)longLiteral)) {
            return this.determineNameOfCalledMacroIfExpanded(longLiteral);
        }
        return LongStringCheck.determineNameOfCalledFunction(tokens, longestLiteralIndex);
    }

    private String determineNameOfCalledMacroIfExpanded(IToken longLiteral) throws CheckException {
        if (!PreprocessedTokenStreamUtils.isTokenMacroExpanded((IToken)longLiteral)) {
            return "";
        }
        List tokensBeforePreprocessing = this.context.getTokens(ECodeViewOption.FILTERED);
        int indexOfCalledMacroToken = LongStringCheck.findCalledMacroTokenInCodeBeforePreprocessing(longLiteral, tokensBeforePreprocessing);
        if (indexOfCalledMacroToken != -1) {
            return ((IToken)tokensBeforePreprocessing.get(indexOfCalledMacroToken)).getText();
        }
        return "";
    }

    private static String determineNameOfCalledFunction(List<IToken> tokens, int longestLiteralIndex) {
        int lparenIndex = LongStringCheck.findPreviousTopLevelOpenParen(tokens, longestLiteralIndex);
        if (lparenIndex != -1 && lparenIndex != 0 && tokens.get(lparenIndex - 1).getType() == ETokenType.IDENTIFIER) {
            return tokens.get(lparenIndex - 1).getText();
        }
        return "";
    }

    @VisibleForTesting
    static int findPreviousTopLevelOpenParen(List<IToken> tokens, int startTokenIndex) {
        int reversedStart;
        SequencedCollection reverseTokens = tokens.reversed();
        int reversedResult = TokenStreamUtils.findFirstTopLevel((List)reverseTokens, (int)(reversedStart = tokens.size() - startTokenIndex), (ITokenMatcher)ETokenType.LPAREN, List.of(ETokenType.RPAREN), List.of(ETokenType.LPAREN));
        if (reversedResult == -1) {
            return -1;
        }
        return tokens.size() - reversedResult - 1;
    }

    private int findLongestLiteralIndex(ShallowEntity entity) {
        IToken longestLiteralToken = null;
        int longestLiteralLength = 0;
        for (List tokenSegment : entity.ownTokens()) {
            for (int i = 0; i < tokenSegment.size(); ++i) {
                String text;
                IToken token = (IToken)tokenSegment.get(i);
                if (i > 0 && ((IToken)tokenSegment.get(i - 1)).getType() == ETokenType.STRING_LITERAL || token.getType() != ETokenType.STRING_LITERAL || (text = LongStringCheck.determineTextForAdjacentString(i, tokenSegment)).length() <= this.maxStringLength || text.length() <= longestLiteralLength) continue;
                longestLiteralToken = token;
                longestLiteralLength = text.length();
            }
        }
        if (longestLiteralToken == null) {
            return -1;
        }
        return entity.includedTokens().indexOf(longestLiteralToken);
    }

    private static String determineTextForAdjacentString(int startStringLiteralIndex, List<IToken> tokens) {
        String initialTokenText = tokens.get(startStringLiteralIndex).getText();
        StringBuilder literalText = initialTokenText.startsWith("@\"") ? new StringBuilder(initialTokenText.substring(2, initialTokenText.length() - 1)) : new StringBuilder(initialTokenText.substring(1, initialTokenText.length() - 1));
        for (int i = startStringLiteralIndex + 1; i < tokens.size(); ++i) {
            IToken token = tokens.get(i);
            if (token.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT) continue;
            if (token.getType() != ETokenType.STRING_LITERAL) break;
            String tokenText = tokens.get(i).getText();
            if (tokenText.startsWith("\"") && tokenText.length() >= 2) {
                literalText.append(tokenText, 1, tokenText.length() - 1);
                continue;
            }
            if (!tokenText.startsWith("@\"") || tokenText.length() < 3) continue;
            literalText.append(tokenText, 2, tokenText.length() - 1);
        }
        return literalText.toString();
    }

    private IToken determineFindingTargetToken(IToken longLiteral) throws CheckException {
        if (!PreprocessedTokenStreamUtils.isTokenMacroExpanded((IToken)longLiteral)) {
            return longLiteral;
        }
        List tokensBeforePreprocessing = this.context.getTokens(ECodeViewOption.FILTERED);
        int calledMacroTokenIndex = LongStringCheck.findCalledMacroTokenInCodeBeforePreprocessing(longLiteral, tokensBeforePreprocessing);
        if (calledMacroTokenIndex + 1 >= tokensBeforePreprocessing.size() || ((IToken)tokensBeforePreprocessing.get(calledMacroTokenIndex + 1)).getType() != ETokenType.LPAREN) {
            return (IToken)tokensBeforePreprocessing.get(calledMacroTokenIndex);
        }
        for (IToken tokenInMacroParameters : TokenStreamUtils.tokensBetweenWithNesting((List)tokensBeforePreprocessing, (int)(calledMacroTokenIndex + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN)) {
            if (tokenInMacroParameters.getType() != longLiteral.getType() || !tokenInMacroParameters.getText().equals(longLiteral.getText())) continue;
            return tokenInMacroParameters;
        }
        return (IToken)tokensBeforePreprocessing.get(calledMacroTokenIndex);
    }

    private String buildFindingMessage(String literalWithoutQuotes) {
        int maxStrLiteralIndexForMsg = 6;
        if (literalWithoutQuotes.isEmpty()) {
            return "String \"\" above the maximum length of " + this.maxStringLength;
        }
        if (literalWithoutQuotes.length() < 6) {
            String formattedAsCode = MarkupUtils.formatAsSourceCode((String)("\"" + literalWithoutQuotes + "\""));
            return "String " + formattedAsCode + " above the maximum length of " + this.maxStringLength;
        }
        String formattedAsCode = MarkupUtils.formatAsSourceCode((String)("\"" + literalWithoutQuotes.substring(0, 6) + "\""));
        return "String starting with " + formattedAsCode + " above the maximum length of " + this.maxStringLength;
    }
}

