/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.cpp.misra.CppGlobalDeclarationsExtractorPhase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-compatible-declaration-shall-be-visible", languages={ELanguage.C, ELanguage.OBJECTIVE_C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={CppGlobalDeclarationsExtractorPhase.class})
public class CompatibleDeclarationShallBeVisible
extends CheckImplementationBase {
    @CheckOption(name="Excluded function names", description="Comma-separated list of function names that are excluded by this check.")
    private Set<String> excludedFunctionNames = Collections.singleton("main");

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        if (this.context.getLanguage() == ELanguage.OBJECTIVE_C) {
            return;
        }
        List allTopLevelEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntity prevEntity = null;
        for (ShallowEntity entity : allTopLevelEntities) {
            if (entity.getType() == EShallowEntityType.METHOD && entity.getSubtype().equals("function") && (prevEntity == null || !prevEntity.getSubtype().equals("template"))) {
                this.processMethodEntity(entity);
            }
            if (entity.getType() == EShallowEntityType.ATTRIBUTE) {
                this.processAttributeEntity(entity);
            }
            prevEntity = entity;
        }
    }

    private void processAttributeEntity(ShallowEntity entity) throws CheckException {
        if (this.isInternallyLinked(entity) || CompatibleDeclarationShallBeVisible.isClassVariable(entity) || CppGlobalDeclarationsExtractorPhase.isExternal(entity) && !TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.EQ)) {
            return;
        }
        if (!this.isVariableDeclaredPriorDefinition(entity)) {
            this.buildFinding("No compatible declaration is visible for `" + entity.getName() + "`", this.buildLocation().forTokens((List)entity.ownStartTokens())).createAndStore();
        }
    }

    private static boolean isClassVariable(ShallowEntity attributeEntity) {
        UnmodifiableList entityStartTokens = attributeEntity.ownStartTokens();
        List variableDefinition = TokenStreamUtils.firstTokenOfTypeSequences((List)entityStartTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.SCOPE, ETokenType.IDENTIFIER});
        if (variableDefinition.isEmpty()) {
            return false;
        }
        int variableNameTokenIndex = (Integer)variableDefinition.get(0) + 1;
        return entityStartTokens.size() > variableNameTokenIndex && ((IToken)entityStartTokens.get(variableNameTokenIndex)).getText().equals(attributeEntity.getName());
    }

    private boolean isVariableDeclaredPriorDefinition(ShallowEntity attributeEntity) {
        Function literalsToUniformPath = this.context.accessPhaseInvertedResult(CppGlobalDeclarationsExtractorPhase.class);
        List declarations = (List)literalsToUniformPath.apply(attributeEntity.getName());
        return !CppGlobalDeclarationsExtractorPhase.isExternal(attributeEntity) && declarations.stream().anyMatch(CppGlobalDeclarationsExtractorPhase.GlobalDeclaration::isExternal);
    }

    private void processMethodEntity(ShallowEntity entity) throws CheckException {
        if (this.isInternallyLinked(entity) || CompatibleDeclarationShallBeVisible.isClassMethodDefinition(entity) || this.excludedFunctionNames.contains(entity.getName())) {
            return;
        }
        Function literalsToUniformPath = this.context.accessPhaseInvertedResult(CppGlobalDeclarationsExtractorPhase.class);
        List declarations = (List)literalsToUniformPath.apply(entity.getName());
        if (CollectionUtils.isNullOrEmpty((Collection)declarations)) {
            this.buildFinding("No compatible declaration is visible for `" + entity.getName() + "`", this.buildLocation().forTokens((List)entity.ownStartTokens())).createAndStore();
        }
    }

    private boolean isInternallyLinked(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.contains((List)tokens, (ETokenType)ETokenType.EXTERN)) {
            return false;
        }
        return LanguageFeatureParser.CPP.entityHasInternalLinkage(entity) || this.lineContainsStaticOrConstBeforeEntity(entity);
    }

    private boolean lineContainsStaticOrConstBeforeEntity(ShallowEntity entity) throws CheckException {
        if (entity.ownStartTokens().isEmpty()) {
            return false;
        }
        IToken firstEntityToken = (IToken)entity.ownStartTokens().get(0);
        int firstEntityTokenLine = firstEntityToken.getLineNumber();
        List tokens = this.context.getTokens(this.getCodeViewOption());
        int firstEntityTokenIndex = TokenStreamUtils.indexOfByOffset((List)tokens, (int)firstEntityToken.getOffset());
        for (int index = firstEntityTokenIndex - 1; index > 0; --index) {
            IToken token = (IToken)tokens.get(index);
            if (token.getLineNumber() != firstEntityTokenLine) {
                return false;
            }
            ETokenType tokenType = token.getType();
            if (this.context.getLanguage() == ELanguage.C && tokenType == ETokenType.STATIC) {
                return true;
            }
            if (tokenType != ETokenType.STATIC && tokenType != ETokenType.CONST) continue;
            return true;
        }
        return false;
    }

    private static boolean isClassMethodDefinition(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.METHOD) {
            return false;
        }
        UnmodifiableList entityStartTokens = entity.ownStartTokens();
        List methodDefinitionHeads = TokenStreamUtils.firstTokenOfTypeSequences((List)entityStartTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.SCOPE, ETokenType.IDENTIFIER, ETokenType.LPAREN});
        if (methodDefinitionHeads.isEmpty()) {
            return false;
        }
        int methodNameTokenIndex = (Integer)methodDefinitionHeads.get(0) + 1;
        return entityStartTokens.size() > methodNameTokenIndex && ((IToken)entityStartTokens.get(methodNameTokenIndex)).getText().equals(entity.getName());
    }
}

