/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

public class CppGlobalDeclarationsExtractorPhase
implements IGlobalExtractionPhase<GlobalDeclaration, TextRegionLocationWithSignatureDetails> {
    private static final String TOP_LEVEL_ENTITIES_XPATH = "./METHOD[subtype('function declaration')|subtype('function pointer declaration')]|./ATTRIBUTE";

    public List<GlobalDeclaration> extract(ITokenElementContext fileContext) throws CheckException {
        ArrayList<GlobalDeclaration> globalDeclarations = new ArrayList<GlobalDeclaration>();
        String uniformPath = fileContext.getUniformPath();
        ShallowEntity rootEntity = fileContext.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED);
        globalDeclarations.addAll(CppGlobalDeclarationsExtractorPhase.extractGlobalDeclarations(uniformPath, rootEntity));
        globalDeclarations.addAll(CppGlobalDeclarationsExtractorPhase.extractExternCDeclarations(uniformPath, rootEntity));
        globalDeclarations.addAll(CppGlobalDeclarationsExtractorPhase.extractFunctionLevelExternDeclarations(uniformPath, rootEntity));
        return globalDeclarations;
    }

    private static List<GlobalDeclaration> extractGlobalDeclarations(String uniformPath, ShallowEntity rootEntity) throws CheckException {
        return CollectionUtils.filterAndMap((Collection)CheckImplementationBase.select((ShallowEntity)rootEntity, (String)TOP_LEVEL_ENTITIES_XPATH), selected -> !CppGlobalDeclarationsExtractorPhase.isLikelyMacroRemainder(selected) && (!LanguageFeatureParser.CPP.entityHasInternalLinkage(selected) || CppGlobalDeclarationsExtractorPhase.isExternal(selected)), selected -> new GlobalDeclaration(uniformPath, selected.getName(), new TextRegionLocationWithSignatureDetails(uniformPath, (ShallowEntity)selected, CppGlobalDeclarationsExtractorPhase.isExternal(selected))));
    }

    private static boolean isLikelyMacroRemainder(ShallowEntity entity) {
        for (IToken token : entity.ownStartTokens()) {
            if (token.getType() == ETokenType.IDENTIFIER) continue;
            return false;
        }
        return true;
    }

    private static List<GlobalDeclaration> extractExternCDeclarations(String uniformPath, ShallowEntity rootEntity) throws CheckException {
        List externCBlockEntities = CheckImplementationBase.select((ShallowEntity)rootEntity, (String)"/META[subtype('extern C block')]");
        ArrayList allDeclarationsInExternCBlocks = new ArrayList();
        for (ShallowEntity externCBlockEntity : externCBlockEntities) {
            allDeclarationsInExternCBlocks.addAll(CheckImplementationBase.select((ShallowEntity)externCBlockEntity, (String)TOP_LEVEL_ENTITIES_XPATH));
        }
        return CollectionUtils.map(allDeclarationsInExternCBlocks, selected -> new GlobalDeclaration(uniformPath, selected.getName(), new TextRegionLocationWithSignatureDetails(uniformPath, (ShallowEntity)selected, CppGlobalDeclarationsExtractorPhase.isExternal(selected))));
    }

    private static Collection<? extends GlobalDeclaration> extractFunctionLevelExternDeclarations(String uniformPath, ShallowEntity rootEntity) throws CheckException {
        List functionLevelLocalVariables = CheckImplementationBase.select((ShallowEntity)rootEntity, (String)".//STATEMENT[subtype('local variable')]");
        return CollectionUtils.filterAndMap((Collection)functionLevelLocalVariables, selected -> CppGlobalDeclarationsExtractorPhase.isExternal(selected) && !LanguageFeatureParser.CPP.entityHasInternalLinkage(selected), selected -> new GlobalDeclaration(uniformPath, selected.getName(), new TextRegionLocationWithSignatureDetails(uniformPath, (ShallowEntity)selected, true)));
    }

    public static boolean isExternal(ShallowEntity entity) {
        if ("function declaration".equals(entity.getSubtype())) {
            EnumSet<ETokenType> targetTokenTypes = EnumSet.of(ETokenType.STATIC, ETokenType.INLINE);
            return !TokenStreamUtils.containsAny((List)entity.ownStartTokens(), targetTokenTypes);
        }
        return TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.EXTERN);
    }

    public EnumSet<ELanguage> getLanguages() {
        return LanguageGroups.C_CPP_AND_MS_CLI;
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    public GlobalDeclaration createValue(String uniformPath, String value, TextRegionLocationWithSignatureDetails additionalInformation) {
        return new GlobalDeclaration(uniformPath, value, additionalInformation);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    @IndexValueClass
    public static class GlobalDeclaration
    implements IExtractedValue<TextRegionLocationWithSignatureDetails> {
        private final String uniformPath;
        private final String declaredObjectName;
        private final TextRegionLocationWithSignatureDetails locationAndExternal;

        private GlobalDeclaration(String uniformPath, String declaredObjectName, TextRegionLocationWithSignatureDetails locationAndExternal) {
            this.uniformPath = uniformPath;
            this.declaredObjectName = declaredObjectName;
            this.locationAndExternal = locationAndExternal;
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.declaredObjectName;
        }

        public boolean isExternal() {
            return this.locationAndExternal.signature.isExternalDeclaration();
        }

        public TextRegionLocationWithSignatureDetails getAdditionalInformation() {
            return this.locationAndExternal;
        }

        public int getStartOffset() {
            return this.locationAndExternal.getLocation().getRawStartOffset();
        }

        public int getEndOffset() {
            return this.locationAndExternal.getLocation().getRawEndOffset();
        }
    }

    @IndexValueClass
    public static class TextRegionLocationWithSignatureDetails
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TextRegionLocation location;
        private final DeclarationSignature signature;

        private TextRegionLocationWithSignatureDetails(String uniformPath, ShallowEntity entity, boolean external) {
            this.location = new TextRegionLocation(uniformPath, entity.getStartOffset(), entity.getEndOffset(), entity.getStartLine(), entity.getEndLine());
            this.signature = this.extractSignature(entity, external);
        }

        private DeclarationSignature extractSignature(ShallowEntity entity, boolean external) {
            EShallowEntityType type = entity.getType();
            if (entity.getType() == EShallowEntityType.METHOD) {
                List<String> paramTypes = TextRegionLocationWithSignatureDetails.changeOptionalEmptyToNull(LanguageFeatureParser.CPP.getParameterTypeNames(entity));
                String returnType = LanguageFeatureParser.CPP.getReturnType(entity);
                return new DeclarationSignature(external, type, paramTypes, returnType);
            }
            return new DeclarationSignature(external, type, null, null);
        }

        private static List<String> changeOptionalEmptyToNull(List<Optional<String>> parameterTypeNames) {
            ArrayList<String> result = new ArrayList<String>(parameterTypeNames.size());
            for (Optional<String> item : parameterTypeNames) {
                if (item.isEmpty()) {
                    result.add(null);
                    continue;
                }
                result.add(item.get());
            }
            return result;
        }

        public TextRegionLocation getLocation() {
            return this.location;
        }

        public DeclarationSignature getSignature() {
            return this.signature;
        }
    }

    @IndexValueClass
    public record DeclarationSignature(boolean isExternalDeclaration, EShallowEntityType entityType, @Nullable List<@Nullable String> paramTypes, @Nullable String returnType) implements Serializable
    {
    }
}

