/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-post-operator-in-return-statement", languages={ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.PHP, ELanguage.XTEND, ELanguage.SWIFT, ELanguage.GROOVY, ELanguage.KOTLIN}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PostOperatorInReturnStatementCheck
extends CheckImplementationBase {
    private static final String FINDINGS_MESSAGE = "Post-operator without effect: ";
    private static final Set<String> FUNCTION_EXPRESSIONS = Set.of("lambda", "lambda expression", "attribute function", "method", "anonymous method", "anonymous function", "anonymous class");

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"return".equals(statement.getName())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList entityTokens = entity.includedTokens();
        List postOperatorVariableIndices = TokenStreamUtils.firstTokenOfTypeSequences((List)entityTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.PLUSPLUS});
        postOperatorVariableIndices.addAll(TokenStreamUtils.firstTokenOfTypeSequences((List)entityTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.MINUSMINUS}));
        Iterator iterator = postOperatorVariableIndices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            String variable = ((IToken)entityTokens.get(index)).getText();
            if (!this.isLocalVariable(variable, index, entity, (List<IToken>)entityTokens) || !PostOperatorInReturnStatementCheck.isLastVariableRead(Set.copyOf(postOperatorVariableIndices), variable, index, (List<IToken>)entityTokens)) continue;
            this.buildFinding(FINDINGS_MESSAGE + variable + ((IToken)entityTokens.get(index + 1)).getText(), this.buildLocation().forToken((IToken)entityTokens.get(index))).createAndStore();
        }
    }

    private boolean isLocalVariable(String variable, int index, ShallowEntity rootStatement, List<IToken> tokens) {
        int absoluteIndex = index + rootStatement.getStartTokenIndex();
        return !PostOperatorInReturnStatementCheck.isAttributeOrMember(index, tokens) && !PostOperatorInReturnStatementCheck.isInsideFunctionExpression(absoluteIndex, rootStatement) && this.isVariableDefinedLocally(variable, rootStatement);
    }

    private boolean isVariableDefinedLocally(String variable, ShallowEntity rootStatement) {
        ShallowEntity parent = rootStatement.getParent();
        UnmodifiableList allChildren = parent.getChildren();
        int rootIndex = allChildren.indexOf(rootStatement);
        List children = allChildren.subList(0, rootIndex);
        for (ShallowEntity child : children) {
            if (!variable.equals(child.getName()) || !this.isVariableWithLocalScope(child)) continue;
            return true;
        }
        if (parent.getType() == EShallowEntityType.METHOD) {
            return false;
        }
        return this.isVariableDefinedLocally(variable, parent);
    }

    private static boolean isInsideFunctionExpression(int absoluteIndex, ShallowEntity statement) {
        for (ShallowEntity child : statement.getChildren()) {
            if (!FUNCTION_EXPRESSIONS.contains(child.getSubtype()) || child.getStartTokenIndex() >= absoluteIndex || child.getEndTokenIndex() < absoluteIndex) continue;
            return true;
        }
        return false;
    }

    private static boolean isLastVariableRead(Collection<Integer> postOperatorVariableIndices, String variable, int index, List<IToken> tokens) {
        List<Integer> reads = TokenStreamTextUtils.findAll(tokens, (String)variable).stream().filter(i -> ((IToken)tokens.get((int)i)).getType() == ETokenType.IDENTIFIER).toList();
        return !reads.isEmpty() && reads.get(reads.size() - 1) == index || postOperatorVariableIndices.containsAll(reads.subList(reads.indexOf(index), reads.size()));
    }

    private static boolean isAttributeOrMember(int index, List<IToken> tokens) {
        if (index == 0) {
            return true;
        }
        ETokenType previousTokenType = tokens.get(index - 1).getType();
        return previousTokenType == ETokenType.DOT;
    }

    private static boolean isStaticVariable(ShallowEntity declarationEntity) {
        return TokenStreamUtils.contains((List)declarationEntity.ownStartTokens(), (ETokenType)ETokenType.STATIC);
    }

    private static boolean isSimpleStatement(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.STATEMENT && entity.getSubtype().equals("simple statement");
    }

    private static boolean isGlobalPhpVariable(ShallowEntity declarationEntity) {
        return TokenStreamUtils.contains((List)declarationEntity.ownStartTokens(), (ETokenType)ETokenType.GLOBAL);
    }

    private static boolean isLocalScopeGroovyVariable(ShallowEntity declarationEntity) {
        return TokenStreamUtils.contains((List)declarationEntity.ownStartTokens(), (ETokenType)ETokenType.DEF);
    }

    private boolean isVariableWithLocalScope(ShallowEntity declarationEntity) {
        return switch (this.context.getLanguage()) {
            case ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI -> {
                if (ShallowParsingUtils.isLocalVariable((ShallowEntity)declarationEntity) && !PostOperatorInReturnStatementCheck.isStaticVariable(declarationEntity)) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.PHP -> {
                if ((PostOperatorInReturnStatementCheck.isSimpleStatement(declarationEntity) || ShallowParsingUtils.isLocalVariable((ShallowEntity)declarationEntity)) && !PostOperatorInReturnStatementCheck.isStaticVariable(declarationEntity) && !PostOperatorInReturnStatementCheck.isGlobalPhpVariable(declarationEntity)) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.GROOVY -> {
                if (ShallowParsingUtils.isLocalVariable((ShallowEntity)declarationEntity) && PostOperatorInReturnStatementCheck.isLocalScopeGroovyVariable(declarationEntity)) {
                    yield true;
                }
                yield false;
            }
            default -> ShallowParsingUtils.isLocalVariable((ShallowEntity)declarationEntity);
        };
    }
}

