/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.JavaAnalysisUtils;
import eu.cqse.check.framework.util.JavaExpressionTypeExtractor;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S5838", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION}, target={ECheckTarget.TEST_CODE})
public class AssertionCanBeSimplifiedCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final JavaMethodCallMatcher ASSERT_J_ASSERTIONS_MATCHER = JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.ASSERT_J.getAssertionTypes()).withTargetMethodNames(new String[]{"assertThat", "assertThatObject"}).withParameterCount(1).withParameters(assertThatParameters -> !AssertionCanBeSimplifiedCheck.ignoreAssertion((List)assertThatParameters.getFirst()));
    private static final List<SimplificationInfo> ASSERT_J_SIMPLIFICATIONS = AssertionCanBeSimplifiedCheck.loadSimplificationsTsv();

    private static List<SimplificationInfo> loadSimplificationsTsv() {
        ArrayList<SimplificationInfo> simplifications = new ArrayList<SimplificationInfo>();
        String tsv = Resource.of(AssertionCanBeSimplifiedCheck.class, (String)"AssertionCanBeSimplifiedCheck/assertj-simplifications.tsv").getContent();
        String[] lines = StringUtils.splitLines((String)tsv);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i == 0 || line.isEmpty()) continue;
            String[] columns = StringUtils.splitByWholeSeparator((String)line, (String)"\t");
            if (columns.length < 3) {
                LOGGER.error("Encountered invalid line, expected 3+ TSV columns: {}", (Object)line);
                continue;
            }
            if (columns[1].startsWith(".")) {
                LOGGER.error("Encountered invalid line, assertion should not have '.' prefix: {}", (Object)line);
                continue;
            }
            if (columns[0].contains(" ")) {
                LOGGER.error("Spaces in first column will never be matched to due token concatenation: {}", (Object)line);
                continue;
            }
            simplifications.add(new SimplificationInfo(columns[0], columns[1], Arrays.stream(StringUtils.splitByWholeSeparator((String)columns[2], (String)" or ")).map(String::trim).toList()));
        }
        return simplifications;
    }

    public void execute() throws CheckException {
        ListMap testFrameworkImports = LanguageFeatureParser.JAVA.getTestFrameworkImports((List)this.getRootChildren());
        if (((List)testFrameworkImports.getCollectionOrEmpty((Object)EJavaTestFramework.ASSERT_J)).isEmpty()) {
            return;
        }
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        this.checkAssertJCalls(typeResolver);
    }

    private void checkAssertJCalls(JavaImportSensitiveTypeResolver typeResolver) throws CheckException {
        block0: for (JavaMethodCallMatcher.MethodCall assertThatCall : ASSERT_J_ASSERTIONS_MATCHER.find(this.context, typeResolver)) {
            List assertThatParameters = (List)assertThatCall.parameters().getFirst();
            Optional inferredTypeInAssert = JavaExpressionTypeExtractor.inferExpressionResultType((ShallowEntity)assertThatCall.entity(), (List)assertThatParameters, (ITypeResolution)this.context.getTypeResolution(this.getCodeViewOption()), (JavaImportSensitiveTypeResolver)typeResolver);
            List chainedCalls = assertThatCall.findChainedCalls();
            for (SimplificationInfo simplificationInfo : ASSERT_J_SIMPLIFICATIONS) {
                Optional<JavaMethodCallMatcher.ChainedCall> relevantChainCall = chainedCalls.stream().filter(chainedCall -> StringUtils.matchesAntPattern((String)AssertionCanBeSimplifiedCheck.toNormalizedCodeString(chainedCall.methodName(), chainedCall.parameters()), (String)simplificationInfo.currentAssertion())).findFirst();
                if (relevantChainCall.isEmpty()) continue;
                boolean hasTypeExpression = StringUtils.containsAll((String)simplificationInfo.typePattern, (String[])new String[]{"{", "}"});
                if (hasTypeExpression) {
                    if (!inferredTypeInAssert.isPresent() || !AssertionCanBeSimplifiedCheck.matchesCallPattern((JavaExpressionTypeExtractor.InferTypeResult)inferredTypeInAssert.get(), simplificationInfo.typePattern) && !AssertionCanBeSimplifiedCheck.matchesCallPattern(((JavaExpressionTypeExtractor.InferTypeResult)inferredTypeInAssert.get()).getKnownBaseType(), simplificationInfo.typePattern) || AssertionCanBeSimplifiedCheck.isExcludedMethod(assertThatCall.entity())) continue;
                    this.buildFinding(AssertionCanBeSimplifiedCheck.getFindingMessage(simplificationInfo), this.buildLocation().forToken(relevantChainCall.get().callToken())).createAndStore();
                    continue block0;
                }
                if (!StringUtils.matchesAntPattern((String)JavaAnalysisUtils.removeUnnecessaryBraces((String)AssertionCanBeSimplifiedCheck.toNormalizedCodeString("", assertThatParameters)), (String)simplificationInfo.typePattern) || AssertionCanBeSimplifiedCheck.isExcludedMethod(assertThatCall.entity())) continue;
                this.buildFinding(AssertionCanBeSimplifiedCheck.getFindingMessage(simplificationInfo), this.buildLocation().forToken(relevantChainCall.get().callToken())).createAndStore();
                continue block0;
            }
        }
    }

    private static boolean matchesCallPattern(JavaExpressionTypeExtractor.InferTypeResult inferTypeResult, String typePattern) {
        String expectedPattern;
        String startMarker = "{" + inferTypeResult.inferredType() + "}";
        if (!typePattern.startsWith(startMarker)) {
            return false;
        }
        String actualExpression = TokenStreamTextUtils.concatTokenTexts((List)inferTypeResult.remainingTokensToRight());
        return actualExpression.equals(expectedPattern = StringUtils.stripPrefix((String)typePattern, (String)startMarker)) || StringUtils.matchesAntPattern((String)actualExpression, (String)expectedPattern);
    }

    private static boolean ignoreAssertion(List<IToken> assertThatParameters) {
        return assertThatParameters.isEmpty() || assertThatParameters.getFirst().getType() == ETokenType.NOT || assertThatParameters.stream().anyMatch(token -> token.getType() == ETokenType.ARROW) || new HashSet<ETokenType>(assertThatParameters.stream().map(IToken::getType).toList()).containsAll(List.of(ETokenType.LT, ETokenType.GT));
    }

    private static String toNormalizedCodeString(String prefix, List<IToken> tokens) {
        return prefix + "(" + StringUtils.concat((Iterable)CollectionUtils.map(tokens, token -> {
            if (token.getType() == ETokenType.STRING_LITERAL && !token.getText().equals("\"\"")) {
                return "\"STRING\"";
            }
            return token.getText();
        }), (String)"") + ")";
    }

    private static boolean isExcludedMethod(ShallowEntity statement) {
        return LanguageFeatureParser.JAVA.statementIsInMethodWithEqualsOrHashcodeNamePattern(statement);
    }

    private static String getFindingMessage(SimplificationInfo simplificationInfo) {
        return "Use " + String.join((CharSequence)" or ", simplificationInfo.assertionToUseInstead().stream().map(expression -> "`" + expression + "`").toList()) + " instead";
    }

    private record SimplificationInfo(String typePattern, String currentAssertion, List<String> assertionToUseInstead) {
    }
}

