/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-do-not-use-threads", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class DoNotUseThreadsCheck
extends CheckImplementationBase {
    protected static final String FINDING_MESSAGE = "Using threads is forbidden for Java EE containers";
    private static final TokenPattern EXTENDS_THREAD_PATTERN = LanguageFeatureParser.JAVA.classExtendsPattern().optional(new Object[]{TokenPattern.text((String)"java"), ETokenType.DOT, TokenPattern.text((String)"lang"), ETokenType.DOT}).sequence(new Object[]{TokenPattern.text((String)"Thread")});
    private static final TokenPattern EXTENDS_RUNNABLE_PATTERN = LanguageFeatureParser.JAVA.interfaceExtendsPattern().optional(new Object[]{TokenPattern.text((String)"java"), ETokenType.DOT, TokenPattern.text((String)"lang"), ETokenType.DOT}).sequence(new Object[]{TokenPattern.text((String)"Runnable")});
    private static final TokenPattern IMPLEMENTS_RUNNABLE_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IMPLEMENTS}).regex("\\bRunnable\\b");
    private static final String CLASS_OR_INTERFACE_PATH = "//TYPE[subtype('class') | subtype('interface')]";
    private static final String STATEMENT_PATH = "//STATEMENT";
    private static final ETokenType[] RECOGNITION_SEQUENCE = new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN};
    private static final int MEMBER_NAME_OFFSET = 2;
    private static final String CHECK_NAME = "Using threads is forbidden for Java EE containers";
    @CheckOption(name="Using threads is forbidden for Java EE containers - Allow `Thread::start`", description="If this is true, calls to `Thread::start` are allowed.")
    private boolean allowThreadStart = false;
    @CheckOption(name="Using threads is forbidden for Java EE containers - Allow implements `Runnable`", description="If this is true, classes are allowed to implement the `Runnable` interface.")
    private boolean allowImplementsRunnable = true;
    @CheckOption(name="Using threads is forbidden for Java EE containers - Allow extends `Runnable`", description="If this is true, interfaces are allowed to extend the `Runnable` interface.")
    private boolean allowExtendRunnable = true;

    public void execute() throws CheckException {
        for (ShallowEntity entity : this.select(CLASS_OR_INTERFACE_PATH)) {
            this.processClassEntity(entity);
        }
        if (!this.allowThreadStart) {
            for (ShallowEntity entity : this.select(STATEMENT_PATH)) {
                this.processStatementEntity(entity);
            }
        }
    }

    private void processClassEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        String message = "`" + entity.getName() + "`";
        if (EXTENDS_THREAD_PATTERN.matchesAnywhere((List)tokens)) {
            message = message + " should not inherit from `Thread`";
        } else if (!this.allowExtendRunnable && EXTENDS_RUNNABLE_PATTERN.matchesAnywhere((List)tokens)) {
            message = message + " should not inherit from `Runnable`";
        } else if (!this.allowImplementsRunnable && IMPLEMENTS_RUNNABLE_PATTERN.matchesAnywhere((List)tokens)) {
            message = message + " should not implement `Runnable`";
        } else {
            return;
        }
        this.buildFinding(message, this.buildLocation().forToken((IToken)tokens.get(TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.IDENTIFIER)))).createAndStore();
    }

    private void processStatementEntity(ShallowEntity entity) throws CheckException {
        ScopedTypeLookup typeLookup = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity);
        UnmodifiableList tokens = entity.ownStartTokens();
        List indices = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])RECOGNITION_SEQUENCE);
        for (Integer index : indices) {
            String variableName = ((IToken)tokens.get(index.intValue())).getText();
            String memberName = ((IToken)tokens.get(index + 2)).getText();
            if (!memberName.equals("start") || !typeLookup.containsVariable(variableName) || !typeLookup.getTypeInfo(variableName).getTypeNameWithoutGenericTypeParameter().endsWith("Thread")) continue;
            this.buildFinding("Thread.start() should not be used", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

