/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-exception-instance-of-check-in-catch", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ExceptionInstanceOfCheckInCatchCheck
extends CheckImplementationBase {
    private static final int INSTANCE_OF_GROUP_ID = 0;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"catch".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity catchEntity) {
        UnmodifiableList tokensInBlock = catchEntity.includedTokens();
        IToken exceptionVariableToken = CLikeLanguageFeatureParserBase.getVariableNameFromCatchTokens((List)tokensInBlock);
        if (exceptionVariableToken == null) {
            return;
        }
        String exceptionVariableName = exceptionVariableToken.getText();
        List instanceOfCheckMatches = new TokenPattern().regex(ExceptionInstanceOfCheckInCatchCheck.getRegexForVariableName(exceptionVariableName)).sequence(new Object[]{ETokenType.INSTANCEOF}).group(0).regex("\\w*Exception\\w*").findAll((List)tokensInBlock);
        for (TokenPatternMatch instanceOfCheckMatch : instanceOfCheckMatches) {
            MatchGroupElement instanceofElement = (MatchGroupElement)instanceOfCheckMatch.getMatchGroup(0).get(0);
            this.buildFinding("`instanceof` check for `" + exceptionVariableName + "` within catch block", this.buildLocation().forToken((IToken)instanceofElement.getTokens().get(0))).createAndStore();
        }
    }

    private static String getRegexForVariableName(String variableName) {
        return "\\b" + variableName + "\\b";
    }
}

