/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.clike.CatchUnwantedExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-java-catch-unwanted-exception", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaCatchUnwantedExceptionCheck
extends CatchUnwantedExceptionCheckBase {
    public static final String CHECK_OPTION_NAME = "Unwanted catch of exception (Java): Exception names";
    private static final Set<String> DEFAULT_EXCEPTION_NAMES = CollectionUtils.asUnmodifiable((Set)JavaLanguageFeatureParser.generateExceptionNamesSet((Class[])new Class[]{NullPointerException.class, ArithmeticException.class, IndexOutOfBoundsException.class, ClassCastException.class, IllegalArgumentException.class, IllegalStateException.class, UnsupportedOperationException.class}));
    @CheckOption(name="Unwanted catch of exception (Java): Exception names", description="List of exception names for which a finding is generated.")
    private Set<String> exceptionNames = new HashSet<String>(DEFAULT_EXCEPTION_NAMES);

    protected boolean createFindingForException(Optional<String> className, ShallowEntity entity) {
        return className.filter(this.exceptionNames::contains).isPresent();
    }
}

