/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.clike.CLikeMethodParameterCountCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import java.util.List;

@Check(id="cqse-java-method-parameter-count", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaMethodParameterCountCheck
extends CLikeMethodParameterCountCheckBase {
    private static final String CHECK_NAME = "Methods should not have too many parameters (Java)";
    @CheckOption(name="Methods should not have too many parameters (Java): max. parameters", description="Maximum parameter count")
    private int maxNumberOfAllowedParameters = 7;
    private static final String OVERRIDE_ANNOTATION_NAME = "Override";

    @Override
    protected int getMaximumAllowedParameterCount() {
        return this.maxNumberOfAllowedParameters;
    }

    @Override
    protected boolean isDerivedMethod(ShallowEntity methodEntity) {
        List annotations = CLikeLanguageFeatureParserBase.getAnnotations((ShallowEntity)methodEntity);
        return annotations.stream().anyMatch(entity -> OVERRIDE_ANNOTATION_NAME.equals(entity.getName()));
    }
}

