/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-javax-ws-rs-query-param-value", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaxWsRsQueryParamValueCheck
extends CheckImplementationBase {
    protected static final String CHECK_NAME = "Avoid special characters in 'javax.ws.rs.QueryParam' annotation parameters";
    private static final String FINDING_MESSAGE = "Avoid special characters in 'javax.ws.rs.QueryParam' annotation parameters";
    private static final String ANNOTATION_SIMPLE_NAME = "QueryParam";
    private static final String JAVAX_ANNOTATION_QUALIFIED_NAME = "javax.ws.rs.QueryParam";
    private static final String JAKARTA_ANNOTATION_QUALIFIED_NAME = "jakarta.ws.rs.QueryParam";
    @CheckOption(name="javax.ws.rs.QueryParam annotation parameters: Patterns", description="Regular expression that checks annotation parameters.")
    private String expression = "(^$)|([a-zA-Z\\-]+)";
    private Pattern expressionPattern;

    public void initialize() throws CheckException {
        super.initialize();
        this.expressionPattern = Pattern.compile(this.expression);
    }

    public void execute() throws CheckException {
        if (!this.hasJavaxWsRsQueryParamImport()) {
            return;
        }
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            if (selectedEntity.getType() == EShallowEntityType.METHOD && "method".equals(selectedEntity.getSubtype())) {
                this.processEntity(selectedEntity);
            }
            if (selectedEntity.getType() != EShallowEntityType.ATTRIBUTE || !"attribute".equals(selectedEntity.getSubtype())) continue;
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        if (entity.getType() == EShallowEntityType.ATTRIBUTE) {
            List fieldAnnotations = CLikeLanguageFeatureParserBase.getAnnotations((ShallowEntity)entity);
            for (ShallowEntity annotation : fieldAnnotations) {
                UnmodifiableList annotationTokens = annotation.ownStartTokens();
                tokens.addAll((Collection<IToken>)annotationTokens);
            }
        }
        tokens.addAll((Collection<IToken>)entity.ownStartTokens());
        List<Integer> parameterIndices = JavaxWsRsQueryParamValueCheck.getAnnotationParameterIndices(tokens);
        this.validateParameters(entity, tokens, parameterIndices);
    }

    private boolean hasJavaxWsRsQueryParamImport() throws CheckException {
        return !LanguageFeatureParser.JAVA.getImportsByPrefix((List)this.getRootChildren(), new String[]{JAVAX_ANNOTATION_QUALIFIED_NAME, JAKARTA_ANNOTATION_QUALIFIED_NAME}).isEmpty();
    }

    private static List<Integer> getAnnotationParameterIndices(List<IToken> tokens) throws AssertionError {
        List atOperatorIndices = TokenStreamUtils.findAll(tokens, (ITokenMatcher)ETokenType.AT_OPERATOR);
        ArrayList<Integer> parameterIndices = new ArrayList<Integer>();
        for (Integer index : atOperatorIndices) {
            int rParenIndex;
            int annotationStartIndex = index + 1;
            int lParenIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)index, (ITokenMatcher)ETokenType.LPAREN);
            if (annotationStartIndex >= tokens.size() || lParenIndex == -1 || !JavaxWsRsQueryParamValueCheck.hasAnnotationValidName(TokenStreamTextUtils.concatTokenTexts(tokens.subList(annotationStartIndex, lParenIndex))) || (rParenIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)lParenIndex, (ITokenMatcher)ETokenType.RPAREN)) == -1) continue;
            parameterIndices.addAll(TokenStreamUtils.findAll(tokens, (int)lParenIndex, (int)rParenIndex, (ITokenMatcher)ETokenType.STRING_LITERAL));
        }
        return parameterIndices;
    }

    private void validateParameters(ShallowEntity entity, List<IToken> tokens, List<Integer> parameterIndicies) {
        for (Integer index : parameterIndicies) {
            String value = tokens.get(index).getText();
            Matcher matcher = this.expressionPattern.matcher(value = StringUtils.removeDoubleQuotes((String)value));
            if (matcher.matches()) continue;
            this.buildFinding("Avoid special characters in 'javax.ws.rs.QueryParam' annotation parameters", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    private static boolean hasAnnotationValidName(String annotationText) {
        return annotationText.equals(ANNOTATION_SIMPLE_NAME) || annotationText.equals(JAVAX_ANNOTATION_QUALIFIED_NAME) || annotationText.equals(JAKARTA_ANNOTATION_QUALIFIED_NAME);
    }
}

