/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="java:S4604", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SpringAutoConfigurationCheck
extends CheckImplementationBase {
    private static final Set<String> AUTOCONFIGURATION_ANNOTATIONS = Set.of("SpringBootApplication", "EnableAutoConfiguration", "org.springframework.boot.autoconfigure.SpringBootApplication", "org.springframework.boot.autoconfigure.EnableAutoConfiguration");
    private static final Set<String> EXCLUDE_PARAMETERS = Set.of("exclude", "excludeName");
    private static final TokenPattern EXCLUDE_PARAMETER_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText(EXCLUDE_PARAMETERS)}), ETokenType.EQ}).optional(new Object[]{ETokenType.LBRACE}).alternative(new Object[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL});

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processAnnotations(CLikeLanguageFeatureParserBase.getAnnotations((ShallowEntity)type));
        }
    }

    private void processAnnotations(List<ShallowEntity> annotations) {
        for (ShallowEntity annotation : annotations) {
            if (!CLikeLanguageFeatureParserBase.isSpecificAnnotation((ShallowEntity)annotation, AUTOCONFIGURATION_ANNOTATIONS)) continue;
            this.checkAnnotation(annotation);
        }
    }

    private void checkAnnotation(ShallowEntity annotation) {
        if (SpringAutoConfigurationCheck.hasValidExcludeParameter(annotation)) {
            return;
        }
        this.buildFinding("Exclude from the auto-configuration mechanism the beans you don't need", this.buildLocation().forEntity(annotation)).createAndStore();
    }

    private static boolean hasValidExcludeParameter(ShallowEntity annotation) {
        UnmodifiableList annotationTokens = annotation.ownStartTokens();
        return EXCLUDE_PARAMETER_PATTERN.matchesAnywhere((List)annotationTokens);
    }
}

