/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.base.JavaThrowExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-throw-highlevel-java-exceptions", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ThrowHighlevelJavaExceptionsCheck
extends JavaThrowExceptionCheckBase {
    @CheckOption(name="Throw of generic exception: Method annotation filter", description="The check will be disabled if the method is annotated with one of these annotations (comma-separated list).")
    private Set<String> filteredMethodAnnotations = CollectionUtils.asHashSet((Object[])new String[]{"@Override", "@Test"});
    private static final String JAVA_EXCEPTION_PACKAGE = "java.lang";

    public void initialize() {
        this.filteredMethodAnnotations = this.filteredMethodAnnotations.stream().map(String::trim).map(annotationName -> StringUtils.stripPrefix((String)annotationName, (String)"@")).collect(Collectors.toSet());
    }

    protected String getFindingMessage(List<IToken> tokens) {
        return "Throw of generic exception ";
    }

    public boolean skipMethod(ShallowEntity entity) {
        List annotations = CLikeLanguageFeatureParserBase.getAnnotations((ShallowEntity)entity);
        return annotations.stream().map(ShallowEntity::getName).anyMatch(this.filteredMethodAnnotations::contains);
    }

    public boolean createFindingForException(List<IToken> tokens, String exceptionClassName) {
        if (TokenStreamTextUtils.concatTokenTexts(tokens).startsWith(JAVA_EXCEPTION_PACKAGE)) {
            return LanguageFeatureParser.JAVA.isGenericExceptionClass(exceptionClassName);
        }
        for (IToken token : tokens) {
            if (token.getType() != ETokenType.IDENTIFIER) continue;
            return LanguageFeatureParser.JAVA.isGenericExceptionClass(token.getText());
        }
        return false;
    }
}

