/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

@Check(id="java:S5777", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidExceptionTestingViaJUnitTestCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.METHOD).forEach(this::handleMethod);
    }

    private void handleMethod(ShallowEntity method) {
        List annotations = CLikeLanguageFeatureParserBase.getAnnotations((ShallowEntity)method);
        Optional<ShallowEntity> testAnnotation = annotations.stream().filter(JavaLanguageFeatureParser::isTestAnnotation).findFirst();
        if (testAnnotation.isEmpty()) {
            return;
        }
        Optional<String> expectException = AvoidExceptionTestingViaJUnitTestCheck.getExpectException(testAnnotation.get());
        if (expectException.isPresent() && AvoidExceptionTestingViaJUnitTestCheck.hasAssertion(method)) {
            this.buildFinding(AvoidExceptionTestingViaJUnitTestCheck.createMessage(expectException.get()), this.buildLocation().forEntity(testAnnotation.get())).createAndStore();
        }
    }

    private static Optional<String> getExpectException(ShallowEntity annotation) {
        List parameterList = TokenStreamUtils.tokensBetween((List)annotation.ownStartTokens(), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        List parameters = TokenStreamUtils.split((List)parameterList, (ETokenType[])new ETokenType[]{ETokenType.COMMA});
        for (List tokens : parameters) {
            if (!TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ}) || !((IToken)tokens.getFirst()).getText().equals("expected")) continue;
            return Optional.of(String.join((CharSequence)"", tokens.stream().map(IToken::getText).toList()));
        }
        return Optional.empty();
    }

    private static boolean hasAssertion(ShallowEntity method) {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)method.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT);
        return statements.stream().anyMatch(AvoidExceptionTestingViaJUnitTestCheck::containsAssertion);
    }

    private static boolean containsAssertion(ShallowEntity statement) {
        Predicate<IToken> predicate = token -> token.getType() == ETokenType.IDENTIFIER && (token.getText().startsWith("assert") || token.getText().startsWith("Assert"));
        return statement.ownStartTokens().stream().anyMatch(predicate);
    }

    private static String createMessage(String code) {
        return "Do not use `%s` while having assertions in test method".formatted(code);
    }
}

