/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.kotlin;

import eu.cqse.check.base.ThrowExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.List;

@Check(id="cqse-throw-highlevel-kotlin-exceptions", languages={ELanguage.KOTLIN}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ThrowHighlevelKotlinExceptionsCheck
extends ThrowExceptionCheckBase {
    protected String getFindingMessage(List<IToken> tokens) {
        return "Throw generic exception ";
    }

    public boolean skipMethod(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD && entity.getSubtype().equals("lambda");
    }

    protected TokenPattern getFindingPattern() {
        return new TokenPattern().sequence(new Object[]{ETokenType.THROW}).sequence(new Object[]{ETokenType.IDENTIFIER, new TokenPattern().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})}).group(0).sequence(new Object[]{ETokenType.LPAREN});
    }

    public boolean createFindingForException(List<IToken> tokens, String exceptionClassName) {
        return LanguageFeatureParser.JAVA.isGenericExceptionClass(exceptionClassName);
    }
}

