/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.simulink.LocalCodeSnippetParser;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.himl_0007", languages={ELanguage.SIMULINK, ELanguage.MATLAB})
public class SimulinkSwitchCaseOtherwiseCheck
extends CheckImplementationBase {
    private static final String RECOMMENDED_ACTION_CASES = "Ensure that each `switch` statement has at least two `case` statements or use an `if-else` otherwise.";
    private static final String RECOMMENDED_ACTION_OTHERWISE = "Ensure that each `switch` statement has an `otherwise` statement containing a comment or at least one statement.";
    @CheckOption(name="Check .m files", description="Run check on .m files")
    private boolean checkMatlabFiles = true;
    private final LocalCodeSnippetParser matlabParser = new LocalCodeSnippetParser(ELanguage.MATLAB);

    public void execute() throws CheckException {
        if (this.context.getLanguage() == ELanguage.MATLAB && this.checkMatlabFiles) {
            this.checkMatlabFile();
        } else if (this.context.getLanguage() == ELanguage.SIMULINK && this.context.getSimulinkContext().getSimulinkModelForModelFile().isPresent()) {
            SimulinkModel model = (SimulinkModel)this.context.getSimulinkContext().getSimulinkModelForModelFile().get();
            for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
                for (String script : StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block)) {
                    this.checkSwitchStatementsInScript(script, this.context.buildLocation().forSimulinkBlock(block));
                }
            }
            for (StateflowState stateflowMatlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
                String script = StateflowUtils.extractMatlabScriptFromStateflowState((StateflowState)stateflowMatlabFunctionState);
                this.checkSwitchStatementsInScript(script, this.context.buildLocation().forStateflowNode((StateflowNodeBase)stateflowMatlabFunctionState));
            }
        }
    }

    private void checkSwitchStatementsInScript(String script, QualifiedNameLocation findingLocation) {
        List scriptTokens = ScannerUtils.getTokens((String)script, (ELanguage)ELanguage.MATLAB, (String)this.context.getUniformPath());
        List<ShallowEntity> parsedScript = this.matlabParser.parseTopLevel(script, this.context.getUniformPath());
        this.checkSwitchEntities(parsedScript, scriptTokens).forEach(p -> this.buildFinding(((CheckFindingAndAction)((Object)((Object)p.getSecond()))).findingMessage, (ElementLocation)findingLocation).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)((CheckFindingAndAction)((Object)((Object)p.getSecond()))).recommendedAction)).createAndStore());
    }

    private void checkMatlabFile() throws CheckException {
        List<ShallowEntity> parsedScript = this.matlabParser.parseTopLevel(this.context.getTextContent(ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT), this.context.getUniformPath());
        this.checkSwitchEntities(parsedScript, this.context.getTokens(ECodeViewOption.UNFILTERED)).forEach(p -> this.buildFinding(((CheckFindingAndAction)((Object)((Object)p.getSecond()))).findingMessage, (ElementLocation)p.getFirst()).addFindingProperties(FindingPropertyList.singleton((String)"Recommended Action", (String)((CheckFindingAndAction)((Object)((Object)p.getSecond()))).recommendedAction)).createAndStore());
    }

    private PairList<ElementLocation, CheckFindingAndAction> checkSwitchEntities(List<ShallowEntity> script, List<IToken> scriptTokens) {
        return ShallowEntityTraversalUtils.listMatchingEntitiesRecursive(script, e -> e.getSubtype().equals("switch")).stream().map(switchEntity -> this.checkSwitchEntity(scriptTokens, (ShallowEntity)switchEntity)).reduce(PairList.emptyPairList(), PairList::concatenate);
    }

    private PairList<ElementLocation, CheckFindingAndAction> checkSwitchEntity(List<IToken> scriptTokens, ShallowEntity switchEntity) {
        return PairList.concatenate(this.checkCaseStatements(switchEntity), this.checkOtherwiseStatements(switchEntity, scriptTokens));
    }

    private PairList<ElementLocation, CheckFindingAndAction> checkCaseStatements(ShallowEntity switchEntity) {
        List childCases = switchEntity.getChildren().stream().filter(child -> child.getSubtype().equals("case")).collect(Collectors.toList());
        if (childCases.isEmpty()) {
            return this.singletonFinding(CheckFindingAndAction.EMPTY_SWITCH_STATEMENT, switchEntity);
        }
        if (childCases.size() < 2) {
            return this.singletonFinding(CheckFindingAndAction.SINGLE_CASE, switchEntity);
        }
        return new PairList();
    }

    private PairList<ElementLocation, CheckFindingAndAction> checkOtherwiseStatements(ShallowEntity switchEntity, List<IToken> scriptTokens) {
        PairList result = new PairList();
        boolean otherwiseAbsent = true;
        for (ShallowEntity entity : switchEntity.getChildren()) {
            if (!entity.getSubtype().equals("otherwise")) continue;
            otherwiseAbsent = false;
            if (!SimulinkSwitchCaseOtherwiseCheck.isEmptyOtherwise(scriptTokens, (IToken)entity.includedTokens().get(0))) continue;
            result.addAll(this.singletonFinding(CheckFindingAndAction.EMPTY_OTHERWISE, switchEntity));
        }
        if (otherwiseAbsent) {
            result.addAll(this.singletonFinding(CheckFindingAndAction.ABSENT_OTHERWISE, switchEntity));
        }
        return result;
    }

    private static boolean isEmptyOtherwise(List<IToken> scriptTokens, IToken otherwiseToken) {
        int otherwiseOffset = TokenStreamUtils.indexOfByOffset(scriptTokens, (int)otherwiseToken.getOffset());
        Preconditions.checkArgument((otherwiseOffset > -1 ? 1 : 0) != 0);
        for (int i = otherwiseOffset + 1; i < scriptTokens.size(); ++i) {
            IToken token = scriptTokens.get(i);
            if (token.getType() == ETokenType.END) {
                return true;
            }
            if (token.getType().getTokenClass() == ETokenType.ETokenClass.WHITESPACE) continue;
            return false;
        }
        return true;
    }

    private PairList<ElementLocation, CheckFindingAndAction> singletonFinding(CheckFindingAndAction findingAndAction, ShallowEntity switchEntity) {
        Optional location = this.buildLocation().forEntity(switchEntity);
        if (location.isPresent()) {
            return PairList.from((Object)((ElementLocation)location.get()), (Object)((Object)findingAndAction));
        }
        return PairList.from((Object)this.buildLocation().forElement(), (Object)((Object)findingAndAction));
    }

    private static enum CheckFindingAndAction {
        EMPTY_SWITCH_STATEMENT("Empty `switch` statement", "Ensure that each `switch` statement has at least two `case` statements or use an `if-else` otherwise."),
        SINGLE_CASE("The `switch` consists of less than two `case` statements", "Ensure that each `switch` statement has at least two `case` statements or use an `if-else` otherwise."),
        EMPTY_OTHERWISE("The `otherwise` statement is empty", "Ensure that each `switch` statement has an `otherwise` statement containing a comment or at least one statement."),
        ABSENT_OTHERWISE("The `switch` statement does not have an `otherwise` statement", "Ensure that each `switch` statement has an `otherwise` statement containing a comment or at least one statement.");

        private final String findingMessage;
        private final String recommendedAction;

        private CheckFindingAndAction(String findingMessage, String recommendedAction) {
            this.findingMessage = findingMessage;
            this.recommendedAction = recommendedAction;
        }
    }
}

