/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0009", languages={ELanguage.SIMULINK})
public class SimulinkSignalNamePropagationCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_ENABLE_PROPAGATION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Propagate the signal name of the output signal of the block.");
    private static final FindingPropertyList RECOMMENDED_ACTION_ADD_NAME = FindingPropertyList.singleton((String)"Recommended Action", (String)"Add a name to the output signal of the block");
    private static final FindingPropertyList RECOMMENDED_ACTION_REMOVE_NAME = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove the signal name and instead propagate the signal name of the output signal of the block.");
    private static final Set<String> RELEVANT_TYPES = Set.of("From", "FunctionCallSplit", "SignalSpecification", "SubSystem");

    public void execute() {
        Optional optionalModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalModel.isEmpty()) {
            return;
        }
        SimulinkModel model = (SimulinkModel)optionalModel.get();
        SimulinkPropagatedSignalLabels propagatedSignalLabels = this.context.getSimulinkContext().getPropagatedSimulinkSignalLabelsForFile().orElse(null);
        for (SimulinkLine line : model.getContainedLinesRecursively(false, false)) {
            if (!SimulinkSignalNamePropagationCheck.needsToBeChecked(line)) continue;
            this.checkSignalNamePropagation(line, propagatedSignalLabels);
        }
    }

    private static boolean needsToBeChecked(SimulinkLine line) {
        SimulinkOutPort srcPort = line.getSrcPort();
        if (srcPort == null) {
            return false;
        }
        SimulinkBlock srcBlock = srcPort.getBlock();
        if (SimulinkUtils.isCommentedBlock((SimulinkBlock)srcBlock)) {
            return false;
        }
        return RELEVANT_TYPES.contains(srcBlock.getType()) && !SimulinkUtils.isLibraryReferenceBlock((SimulinkElementBase)srcBlock);
    }

    private void checkSignalNamePropagation(SimulinkLine line, @Nullable SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        SimulinkOutPort srcPort = line.getSrcPort();
        CCSMAssert.isNotNull((Object)srcPort, (String)"srcPort should have been checked for null before.");
        SimulinkBlock srcBlock = srcPort.getBlock();
        String propagatedSignalName = SimulinkUtils.getPropagatedSignalName((SimulinkOutPort)srcPort, (SimulinkPropagatedSignalLabels)propagatedSignalLabels);
        String blockName = MarkupUtils.formatAsSourceCode((String)srcBlock.getNamePretty());
        String signalName = line.getName().orElse(null);
        boolean propagateSignalLabel = "on".equals(srcPort.getParameter("ShowPropagatedSignals"));
        if (propagatedSignalName != null && !propagateSignalLabel) {
            this.buildFinding("Signal name originating from block " + blockName + " is not propagated", (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_ENABLE_PROPAGATION).createAndStore();
        } else {
            if (signalName != null && propagateSignalLabel) {
                this.buildFinding("Signal name " + MarkupUtils.formatAsSourceCode((String)signalName) + " is set directly", (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_REMOVE_NAME).createAndStore();
            }
            if (propagatedSignalName == null && propagateSignalLabel) {
                this.buildFinding("Empty signal name originating from block " + blockName + " is propagated", (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_ADD_NAME).createAndStore();
            }
        }
    }
}

