/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.design.DiscreteBlock", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfDiscreteTimeIntegratorBlocksDesignCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Move the block that requires elapsed time outside the Iterator Subsystem.");
    private static final Set<String> DISALLOWED_INNER_BLOCK_TYPES = Set.of("UnitDelay", "Delay", "DiscreteIntegrator", "DiscreteTransferFcn", "DiscreteFilter", "DiscreteZeroPole", "Difference", "Discrete Derivative", "DiscreteStateSpace", "First Order Transfer Fcn", "Lead or Lag Compensator", "Transfer Fcn Real Zero", "PID 1dof", "PID 2dof", "Tapped Delay Line", "DiscreteFir", "ZeroOrderHold");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!SimulinkUsageOfDiscreteTimeIntegratorBlocksDesignCheck.isDisallowedBlockType(block)) continue;
            this.checkDisallowedInnerBlock(block);
        }
    }

    private static boolean isDisallowedBlockType(SimulinkBlock block) {
        return block.getType() != null && DISALLOWED_INNER_BLOCK_TYPES.contains(block.getType()) || block.getSourceType() != null && DISALLOWED_INNER_BLOCK_TYPES.contains(block.getSourceType());
    }

    private void checkDisallowedInnerBlock(SimulinkBlock block) {
        if (SimulinkUsageOfDiscreteTimeIntegratorBlocksDesignCheck.hasAnyAncestorWith(block, SimulinkUtils::isForOrWhileIteratorSubsystem)) {
            String message = "Block that requires elapsed time " + MarkupUtils.formatAsSourceCode((String)block.getNamePretty()) + " is used inside Iterator Subsystem";
            this.buildFinding(message, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean hasAnyAncestorWith(SimulinkBlock block, Predicate<SimulinkBlock> predicate) {
        Set parents = SimulinkUtils.calculateParentSet((Collection)CollectionUtils.asHashSet((Object[])new SimulinkBlock[]{block}));
        return parents.stream().anyMatch(predicate);
    }
}

