/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink.phases;

import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.phases.ReferencedItem;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReference;
import eu.cqse.check.simulink.simulink.utils.SimulinkPhaseUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkModel;

public class SimulinkFileReferencesPhase
implements IGlobalExtractionPhase<SimulinkFileReference, String> {
    public boolean needsAccessByValue() {
        return true;
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.SIMULINK);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.RUN_ON_HIDDEN_ELEMENTS);
    }

    public List<SimulinkFileReference> extract(ITokenElementContext fileContext) {
        Optional dataDictionary = fileContext.getSimulinkContext().getSimulinkDataDictionaryForDictionaryFile();
        if (dataDictionary.isPresent()) {
            return SimulinkPhaseUtils.extractReferencesForDataDictionary((SimulinkDataDictionary)dataDictionary.get());
        }
        Optional model = fileContext.getSimulinkContext().getSimulinkModelForModelFile();
        if (model.isPresent()) {
            return SimulinkPhaseUtils.extractReferencesForModel((SimulinkModel)model.get());
        }
        return Collections.emptyList();
    }

    public SimulinkFileReference createValue(String uniformPath, String value, String additionalInformation) {
        return SimulinkFileReference.reference(uniformPath, ReferencedItem.fromStorageString(value));
    }
}

