/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink.utils;

import eu.cqse.check.simulink.simulink.phases.SimulinkFileReference;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.ReferencedBlockInfo;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

public final class SimulinkPhaseUtils {
    public static @NonNull List<SimulinkModelBlockIdListingPhase.BlockIdDefinition> getBlockIdDefinitions(SimulinkModel model) {
        String uniformPath = model.getUniformPath();
        ArrayList<SimulinkModelBlockIdListingPhase.BlockIdDefinition> blockDefinitions = new ArrayList<SimulinkModelBlockIdListingPhase.BlockIdDefinition>();
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("SubSystem"), (boolean)false, (boolean)false)) {
            blockDefinitions.add(new SimulinkModelBlockIdListingPhase.BlockIdDefinition(uniformPath, block.getId()));
        }
        return blockDefinitions;
    }

    public static @NonNull List<SimulinkFileReference> extractReferencesForDataDictionary(SimulinkDataDictionary dataDictionary) {
        String uniformPath = dataDictionary.getUniformPath();
        ArrayList<SimulinkFileReference> references = new ArrayList<SimulinkFileReference>();
        String elementName = UniformPathUtils.getElementName((String)uniformPath);
        references.add(SimulinkFileReference.dictionarySimpleFile(uniformPath, elementName));
        references.addAll(SimulinkPhaseUtils.buildReferencesForSubDictionaries(uniformPath, dataDictionary));
        return references;
    }

    public static @NonNull List<SimulinkFileReference> extractReferencesForModel(SimulinkModel model) {
        String uniformPath = model.getUniformPath();
        ArrayList<SimulinkFileReference> references = new ArrayList<SimulinkFileReference>();
        references.add(SimulinkFileReference.modelSimpleFile(uniformPath, UniformPathUtils.getElementName((String)uniformPath)));
        references.addAll(SimulinkPhaseUtils.buildReferencesFromModelToModel(uniformPath, model));
        references.addAll(SimulinkPhaseUtils.buildReferenceFromModelToDictionary(uniformPath, model));
        return references;
    }

    private static List<SimulinkFileReference> buildReferencesFromModelToModel(String originUniformPath, SimulinkModel originModel) {
        ArrayList<SimulinkFileReference> references = new ArrayList<SimulinkFileReference>();
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)originModel, (boolean)false, (boolean)false)) {
            ReferencedBlockInfo referencedBlockInfo;
            if (SimulinkUtils.isSubsystemReferenceBlock((SimulinkBlock)block)) {
                String targetFileSimpleName = block.getParameter("ReferencedSubsystem");
                references.add(SimulinkFileReference.modelFile(originUniformPath, block.buildQualifiedName(), targetFileSimpleName));
                continue;
            }
            if (block.isOfType("Reference")) {
                referencedBlockInfo = block.getReferencedBlockInfo();
                if (referencedBlockInfo == null) continue;
                references.add(SimulinkFileReference.libraryBlock(originUniformPath, block.buildQualifiedName(), referencedBlockInfo.getBlockName()));
                continue;
            }
            if (!block.isOfType("ModelReference") || (referencedBlockInfo = block.getReferencedBlockInfo()) == null) continue;
            references.add(SimulinkFileReference.modelFile(originUniformPath, block.buildQualifiedName(), referencedBlockInfo.getBlockName()));
        }
        return references;
    }

    private static @NonNull List<SimulinkFileReference> buildReferenceFromModelToDictionary(String uniformPath, SimulinkModel simulinkModel) {
        String dataDictionaryFileName = simulinkModel.getParameter("DataDictionary");
        if (dataDictionaryFileName == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(SimulinkFileReference.dataDictionary(uniformPath, dataDictionaryFileName));
    }

    private static @NonNull List<SimulinkFileReference> buildReferencesForSubDictionaries(String uniformPath, SimulinkDataDictionary dataDictionary) {
        ArrayList<SimulinkFileReference> references = new ArrayList<SimulinkFileReference>();
        for (String subDictionaryFileName : dataDictionary.getSubDataDictionaries()) {
            SimulinkFileReference reference = SimulinkFileReference.dataDictionary(uniformPath, subDictionaryFileName);
            references.add(reference);
        }
        return references;
    }

    private SimulinkPhaseUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

