/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0712", languages={ELanguage.SIMULINK})
public class SimulinkChartExecutionOptionCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "The Stateflow chart executes at Initialization";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider disabling the chart option 'Execute (enter) Chart At Initialization'.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            StateflowBlock stateflowBlock;
            if (!(block instanceof StateflowBlock) || !"1".equals((stateflowBlock = (StateflowBlock)block).getChart().getParameter("executeAtInitialization"))) continue;
            this.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock((SimulinkBlock)stateflowBlock)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

