/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclBase;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0732", languages={ELanguage.SIMULINK})
public class SimulinkDistinctNamesInStateflowChartsCheck
extends CheckImplementationBase {
    private static final String FINDINGS_MESSAGE_DATA = "Stateflow State name matches Stateflow Data name: {0}";
    private static final FindingPropertyList RECOMMENDED_ACTION_DATA = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change either the name of the Stateflow Data or the Stateflow State so that they are not identical.");
    private static final String FINDINGS_MESSAGE_EVENT = "Stateflow State name matches Stateflow Event name: {0}";
    private static final FindingPropertyList RECOMMENDED_ACTION_EVENT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change either the name of the Stateflow Event or the Stateflow State so that they are not identical.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        StateflowUtils.getStateflowChartsFromModel((SimulinkModel)model, (boolean)false).forEach(this::checkChart);
    }

    private void checkChart(StateflowChart chart) {
        Set<String> dataNames = chart.getData().stream().map(StateflowDeclBase::getName).collect(Collectors.toSet());
        this.checkUniqueNamesOf(chart, dataNames, FINDINGS_MESSAGE_DATA, RECOMMENDED_ACTION_DATA);
        Set<String> eventsNames = chart.getEvents().stream().map(StateflowDeclBase::getName).collect(Collectors.toSet());
        this.checkUniqueNamesOf(chart, eventsNames, FINDINGS_MESSAGE_EVENT, RECOMMENDED_ACTION_EVENT);
    }

    private void checkUniqueNamesOf(StateflowChart chart, Set<String> names, String findingsMessage, FindingPropertyList recommendedAction) {
        for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
            if (!names.contains(StateflowUtils.getStateName((StateflowState)state))) continue;
            String message = MessageFormat.format(findingsMessage, MarkupUtils.formatAsSourceCode((String)StateflowUtils.getStateName((StateflowState)state)));
            this.buildFinding(message, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(recommendedAction).createAndStore();
        }
    }
}

