/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0730", languages={ELanguage.SIMULINK})
public class SimulinkStateflowStateNameUniquenessCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "State name `{0}` is not unique in the Stateflow chart `{1}`";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Rename the state to have a unique name.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.getStateflowMachine() == null) {
            return;
        }
        for (StateflowChart chart : model.getStateflowMachine().getCharts(false)) {
            this.checkStateflowChart(chart);
        }
    }

    private void checkStateflowChart(StateflowChart chart) {
        ListMap statesByNames = new ListMap();
        for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
            String name;
            if (!state.isRegularState() || (name = StateflowUtils.getStateName((StateflowState)state)) == null) continue;
            statesByNames.add((Object)name, (Object)state);
        }
        this.createFindingsForDuplicates(chart, (ListMap<String, StateflowNodeBase>)statesByNames);
    }

    private void createFindingsForDuplicates(StateflowChart chart, ListMap<String, StateflowNodeBase> statesByNames) {
        for (String label : statesByNames.getKeys()) {
            List nodesWithLabel = (List)statesByNames.getCollection((Object)label);
            if (nodesWithLabel.size() <= 1) continue;
            String chartName = StringUtils.getLastPart((String)chart.getName(), (String)"/");
            for (StateflowNodeBase node : nodesWithLabel) {
                this.buildFinding(MessageFormat.format(FINDING_MESSAGE, label, chartName), (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }
}

