/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.TransitionLayoutData;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.conqat.lib.simulink.util.geometry.PathBezierApproximationHelper;
import org.conqat.lib.simulink.util.geometry.PathIntersectionCalculator;

@Check(id="cqse.jmaab.db_0129", languages={ELanguage.SIMULINK})
public class SimulinkStateflowTransitionAppearanceCheck
extends CheckImplementationBase {
    private static final PathBezierApproximationHelper PATH_APPROXIMATION_HELPER = new PathBezierApproximationHelper(5);
    private static final String TRANSITION_ORIENTATION_FINDING_MESSAGE = "Transition lines shall be drawn vertically, horizontally or diagonally";
    private static final FindingPropertyList CROSSING_TRANSITIONS_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider remodeling so that transition lines do not cross over or overlap one another.");
    private static final FindingPropertyList TRANSITION_CROSSING_STATES_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider remodeling so that transitions do not cross over other Stateflow objects.");
    private static final FindingPropertyList TRANSITION_ORIENTATION_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider remodeling using either horizontal or vertical transitions only and diagonal transitions for flow chart loops.");
    private static final FindingPropertyList UNNECESSARY_JUNCTION_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider avoiding unnecessary connective junctions.");
    @CheckOption(name="Ignore crossing and overlapping transitions (MAAB rules db_0129_a and db_0129_b)", description="If set, crossing and overlapping transitions (MAAB rules db_0129_a and db_0129_b) are not checked.")
    private boolean ignoreCrossingAndOverlappingTransitions = true;
    @CheckOption(name="Ignore orientation of transition lines (MAAB rules db_0129_d)", description="If set, orientation of transition lines (MAAB rule db_0129_d) are not checked.")
    private boolean ignoreOrientationOfTransitionLines = true;

    public void execute() {
        SimulinkModel simulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (simulinkModel == null) {
            return;
        }
        StateflowMachine stateflowMachine = simulinkModel.getStateflowMachine();
        if (stateflowMachine == null) {
            return;
        }
        for (StateflowChart stateflowChart : stateflowMachine.getCharts(false)) {
            this.analyzeTopLevelChart(stateflowChart);
        }
    }

    private void analyzeTopLevelChart(StateflowChart stateflowChart) {
        for (StateflowChart chart : SimulinkStateflowTransitionAppearanceCheck.listVisibleStateflowCharts(stateflowChart)) {
            Map<GeneralPath, StateflowTransition> pathToTransitions = this.generatePathsForTransitions(chart);
            List visibleNodes = StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)true, (boolean)false);
            if (!this.ignoreCrossingAndOverlappingTransitions) {
                this.checkForCrossingOrOverlappingTransitions(pathToTransitions);
            }
            for (Map.Entry<GeneralPath, StateflowTransition> lineAndTransition : pathToTransitions.entrySet()) {
                this.checkIfTransitionCrossesStates(lineAndTransition.getValue(), visibleNodes, lineAndTransition.getKey());
            }
            for (StateflowNodeBase node : visibleNodes) {
                if (StateflowUtils.isCommented((ParameterizedElement)node)) continue;
                if (!this.ignoreOrientationOfTransitionLines) {
                    this.checkForTransitionOrientation(node);
                }
                this.checkForUnnecessaryJunctions(node);
            }
        }
    }

    private Map<GeneralPath, StateflowTransition> generatePathsForTransitions(StateflowChart chart) {
        Set visibleTransitions = StateflowUtils.getAllTransitionsAsSet((StateflowChart)chart, (boolean)false, (boolean)false);
        HashMap<GeneralPath, StateflowTransition> pathToTransitions = new HashMap<GeneralPath, StateflowTransition>();
        for (StateflowTransition transition : visibleTransitions) {
            GeneralPath line = PATH_APPROXIMATION_HELPER.buildStraightSegments(SimulinkStateflowTransitionAppearanceCheck.createPathFromTransition(transition));
            if (line == null) continue;
            pathToTransitions.put(line, transition);
        }
        return pathToTransitions;
    }

    private static @NonNull List<StateflowChart> listVisibleStateflowCharts(StateflowChart stateflowChart) {
        List allNodes = StateflowUtils.listNodesRecursively((StateflowChart)stateflowChart, (boolean)true);
        ArrayList<StateflowChart> chartsToCheck = new ArrayList<StateflowChart>();
        chartsToCheck.add(stateflowChart);
        for (StateflowNodeBase node : allNodes) {
            if (!(node instanceof StateflowState) || !((StateflowState)node).isSubChart()) continue;
            chartsToCheck.add(((StateflowState)node).getSubViewer());
        }
        return chartsToCheck;
    }

    private static GeneralPath createPathFromTransition(StateflowTransition transition) {
        boolean isStraightHorizontalOrVerticalLine;
        List points = transition.obtainLayoutData().getPoints();
        if (points.isEmpty()) {
            return null;
        }
        String transitionType = transition.getParameter("type");
        if ("SUB".equals(transitionType) || "SUPER".equals(transitionType)) {
            return null;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(((Point)points.get((int)0)).x, ((Point)points.get((int)0)).y);
        boolean bl = isStraightHorizontalOrVerticalLine = points.stream().map(Point2D::getX).distinct().count() == 1L || points.stream().map(Point2D::getY).distinct().count() == 1L;
        if (isStraightHorizontalOrVerticalLine) {
            Point endPoint = (Point)points.get(points.size() - 1);
            path.lineTo(endPoint.getX(), endPoint.getY());
            return path;
        }
        for (int i = 1; i < points.size() - 1; i += 2) {
            path.quadTo(((Point)points.get((int)i)).x, ((Point)points.get((int)i)).y, ((Point)points.get((int)(i + 1))).x, ((Point)points.get((int)(i + 1))).y);
        }
        return path;
    }

    private void checkForCrossingOrOverlappingTransitions(Map<GeneralPath, StateflowTransition> lineToTransitions) {
        ArrayList<GeneralPath> transitionLines = new ArrayList<GeneralPath>(lineToTransitions.keySet());
        HashSet<StateflowTransition> crossingTransitions = new HashSet<StateflowTransition>();
        for (int i = 0; i < transitionLines.size(); ++i) {
            GeneralPath transitionLineOne = (GeneralPath)transitionLines.get(i);
            for (int j = i + 1; j < transitionLines.size(); ++j) {
                GeneralPath transitionLineTwo = (GeneralPath)transitionLines.get(j);
                if (!PathIntersectionCalculator.intersection((GeneralPath)transitionLineOne, (GeneralPath)transitionLineTwo).isPresent()) continue;
                crossingTransitions.add(lineToTransitions.get(transitionLineOne));
                crossingTransitions.add(lineToTransitions.get(transitionLineTwo));
            }
        }
        for (StateflowTransition crossingTransition : crossingTransitions) {
            this.context.buildFinding("Transition lines shall not cross over or overlap one another", (ElementLocation)this.context.buildLocation().forStateflowTransition(crossingTransition)).addFindingProperties(CROSSING_TRANSITIONS_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkIfTransitionCrossesStates(StateflowTransition transition, List<StateflowNodeBase> nodes, GeneralPath path) {
        HashSet<StateflowNodeBase> ignoredNodes = new HashSet<StateflowNodeBase>();
        ignoredNodes.add(transition.getSrc());
        ignoredNodes.addAll(SimulinkStateflowTransitionAppearanceCheck.getAncestorNodes(transition.getSrc()));
        ignoredNodes.add(transition.getDst());
        ignoredNodes.addAll(SimulinkStateflowTransitionAppearanceCheck.getAncestorNodes(transition.getDst()));
        for (StateflowNodeBase node : nodes) {
            Rectangle nodeLayoutPosition;
            if (SimulinkStateflowTransitionAppearanceCheck.isAnnotation(node) || ignoredNodes.contains(node) || !PathIntersectionCalculator.hasIntersection((GeneralPath)path, (Rectangle)(nodeLayoutPosition = node.obtainLayoutData().getPosition()))) continue;
            this.buildFinding("Transition lines shall not cross over states", (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(TRANSITION_CROSSING_STATES_RECOMMENDED_ACTION).createAndStore();
            return;
        }
    }

    private static boolean isAnnotation(StateflowNodeBase node) {
        return node instanceof StateflowState && ((StateflowState)node).isNoteBox();
    }

    private static List<StateflowNodeBase> getAncestorNodes(StateflowNodeBase child) {
        if (child == null) {
            return Collections.emptyList();
        }
        ArrayList<StateflowNodeBase> ancestors = new ArrayList<StateflowNodeBase>();
        IStateflowNodeContainer parent = (IStateflowNodeContainer)child.getParent();
        while (parent instanceof StateflowNodeBase) {
            ancestors.add((StateflowNodeBase)parent);
            if (!(parent.getParent() instanceof IStateflowNodeContainer)) break;
            parent = (IStateflowNodeContainer)parent.getParent();
        }
        return ancestors;
    }

    private void checkIfTransitionIsCurved(StateflowTransition transition) {
        List points = transition.obtainLayoutData().getPoints();
        Point transitionStartPoint = (Point)points.get(0);
        Point transitionEndPoint = (Point)points.get(points.size() - 1);
        long roundedLineDistance = Math.round(transitionStartPoint.distance(transitionEndPoint));
        for (Point point : points) {
            if (Math.round(transitionStartPoint.distance(point) + transitionEndPoint.distance(point)) == roundedLineDistance) continue;
            this.context.buildFinding(TRANSITION_ORIENTATION_FINDING_MESSAGE, (ElementLocation)this.context.buildLocation().forStateflowTransition(transition)).addFindingProperties(TRANSITION_ORIENTATION_RECOMMENDED_ACTION).createAndStore();
            break;
        }
    }

    private void checkForUnnecessaryJunctions(StateflowNodeBase node) {
        StateflowTransition out;
        UnmodifiableSet outTransitions = node.getOutTransitions();
        UnmodifiableSet inTransitions = node.getInTransitions();
        if (!(node instanceof StateflowJunction) || inTransitions.size() != 1 || outTransitions.size() != 1) {
            return;
        }
        StateflowTransition in = (StateflowTransition)inTransitions.stream().findAny().get();
        boolean transitionsHaveSameOrientationCategory = SimulinkStateflowTransitionAppearanceCheck.haveSameOrientationCategory(in, out = (StateflowTransition)outTransitions.stream().findAny().get());
        if (transitionsHaveSameOrientationCategory && (SimulinkStateflowTransitionAppearanceCheck.isTransitionWithoutFunctionality(in) || SimulinkStateflowTransitionAppearanceCheck.isTransitionWithoutFunctionality(out))) {
            this.context.buildFinding("Unnecessary connective junctions shall not be used", (ElementLocation)this.context.buildLocation().forStateflowNode(node)).addFindingProperties(UNNECESSARY_JUNCTION_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkForTransitionOrientation(StateflowNodeBase node) {
        UnmodifiableSet outTransitions = node.getOutTransitions();
        for (StateflowTransition transition : outTransitions) {
            if (StateflowUtils.isInsideLoop((StateflowNodeBase)node)) {
                this.checkIfTransitionIsCurved(transition);
                continue;
            }
            if (StateflowUtils.isVerticalTransition((TransitionLayoutData)transition.obtainLayoutData()) || StateflowUtils.isHorizontalTransition((TransitionLayoutData)transition.obtainLayoutData())) continue;
            this.context.buildFinding(TRANSITION_ORIENTATION_FINDING_MESSAGE, (ElementLocation)this.context.buildLocation().forStateflowTransition(transition)).addFindingProperties(TRANSITION_ORIENTATION_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean haveSameOrientationCategory(StateflowTransition in, StateflowTransition out) {
        int inOrientation = 0;
        TransitionLayoutData inLayout = in.obtainLayoutData();
        if (StateflowUtils.isVerticalTransition((TransitionLayoutData)inLayout)) {
            inOrientation = 1;
        } else if (StateflowUtils.isHorizontalTransition((TransitionLayoutData)inLayout)) {
            inOrientation = 2;
        }
        int outOrientation = 0;
        TransitionLayoutData outLayout = out.obtainLayoutData();
        if (StateflowUtils.isVerticalTransition((TransitionLayoutData)outLayout)) {
            outOrientation = 1;
        } else if (StateflowUtils.isHorizontalTransition((TransitionLayoutData)outLayout)) {
            outOrientation = 2;
        }
        return inOrientation == outOrientation;
    }

    private static boolean isTransitionWithoutFunctionality(StateflowTransition stateflowTransition) {
        String label = stateflowTransition.getLabel();
        if (label == null || label.isEmpty()) {
            return true;
        }
        for (String line : label.split("\\n")) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("%") || trimmedLine.startsWith("//")) continue;
            return false;
        }
        return true;
    }
}

