/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckFindingBuilderBase;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-unquoted-identifiers", languages={ELanguage.SQLSCRIPT})
public class UnquotedIdentifiersCheck
extends CheckImplementationBase {
    private final SetMap<String, IToken> identifierToTokenMap = new SetMap();
    private final SetMap<String, String> normalizedToActualNamesMap = new SetMap();
    private final SetMap<String, ShallowEntity> identifierToEntityMap = new SetMap();

    public void execute() throws CheckException {
        this.identifierToTokenMap.clear();
        this.normalizedToActualNamesMap.clear();
        this.identifierToEntityMap.clear();
        List abstractSyntaxTree = this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED);
        for (ShallowEntity entity : abstractSyntaxTree) {
            this.checkIdentifierAndFillMaps(entity);
        }
        this.checkForMixedUsedUnquotedIdentifiers();
    }

    private void checkIdentifierAndFillMaps(ShallowEntity entity) {
        HashMap<String, CheckFindingBuilderBase> identifierToFinding = new HashMap<String, CheckFindingBuilderBase>();
        for (IToken token : UnquotedIdentifiersCheck.getIdentifiers(entity)) {
            String findingMessage;
            String identifier = token.getText();
            if (UnquotedIdentifiersCheck.isDoubleQuoted(identifier)) continue;
            this.addIdentifierToMaps(token, entity);
            if (UnquotedIdentifiersCheck.isSingleQuoted(identifier)) {
                findingMessage = "Usage of single quotes at " + MarkupUtils.formatAsSourceCode((String)identifier) + " in " + entity.getSubtype();
                this.createFinding(entity, token, identifierToFinding, identifier, findingMessage);
                continue;
            }
            if (!UnquotedIdentifiersCheck.isMixedCased(identifier)) continue;
            findingMessage = "Unquoted identifier " + MarkupUtils.formatAsSourceCode((String)identifier) + " with mixed upper and lower case letters used in " + entity.getSubtype();
            this.createFinding(entity, token, identifierToFinding, identifier, findingMessage);
        }
        UnquotedIdentifiersCheck.storeFindings(identifierToFinding);
    }

    private static List<IToken> getIdentifiers(ShallowEntity entity) {
        return entity.includedTokens().stream().filter(t -> t.getType() == ETokenType.IDENTIFIER).toList();
    }

    private void createFinding(ShallowEntity entity, IToken token, Map<String, CheckFindingBuilderBase> identifierToFinding, String identifier, String findingMessage) {
        Optional textRegionLocation = this.buildLocation().forEntityFirstLine(entity);
        if (textRegionLocation.isEmpty()) {
            return;
        }
        if (!identifierToFinding.containsKey(identifier)) {
            CheckFindingBuilderBase finding = this.buildFinding(findingMessage, textRegionLocation);
            identifierToFinding.put(identifier, finding);
        }
        CheckFindingBuilderBase checkFindingBuilderBase = identifierToFinding.get(identifier);
        Optional secondaryLocation = this.buildLocation().forToken(token);
        secondaryLocation.ifPresent(regionLocation -> checkFindingBuilderBase.addSecondaryLocations(List.of(regionLocation)));
    }

    private static void storeFindings(Map<String, CheckFindingBuilderBase> identifierMap) {
        for (CheckFindingBuilderBase finding : identifierMap.values()) {
            finding.createAndStore();
        }
    }

    private void checkForMixedUsedUnquotedIdentifiers() {
        HashMap<String, CheckFindingBuilderBase> identifierToFinding = new HashMap<String, CheckFindingBuilderBase>();
        for (String normalizedName : this.identifierToTokenMap.getKeys()) {
            Set actualNames = (Set)this.normalizedToActualNamesMap.getCollectionOrEmpty((Object)normalizedName);
            if (actualNames.size() < 2) continue;
            ArrayList sortedNames = CollectionUtils.sort((Collection)actualNames);
            String formattedNames = StringUtils.surroundWith((String)MarkupUtils.formatAsSourceCode((Collection)sortedNames), (String)"[", (String)"]");
            String findingsMessage = "File contains unquoted identifier with different casings " + formattedNames;
            for (IToken token : (Set)this.identifierToTokenMap.getCollectionOrEmpty((Object)normalizedName)) {
                Set entities = (Set)this.identifierToEntityMap.getCollectionOrEmpty((Object)normalizedName);
                for (ShallowEntity entity : entities) {
                    this.createFinding(entity, token, identifierToFinding, normalizedName, findingsMessage);
                }
            }
        }
        UnquotedIdentifiersCheck.storeFindings(identifierToFinding);
    }

    private void addIdentifierToMaps(IToken token, ShallowEntity entity) {
        String normalizedIdentifier = token.getText().toUpperCase();
        this.identifierToTokenMap.add((Object)normalizedIdentifier, (Object)token);
        if (!this.identifierToEntityMap.contains((Object)normalizedIdentifier, (Object)entity)) {
            this.identifierToEntityMap.add((Object)normalizedIdentifier, (Object)entity);
        }
        this.normalizedToActualNamesMap.add((Object)normalizedIdentifier, (Object)token.getText());
    }

    private static boolean isDoubleQuoted(String identifier) {
        return identifier.startsWith("\"") && identifier.endsWith("\"");
    }

    private static boolean isSingleQuoted(String identifier) {
        return identifier.startsWith("'") && identifier.endsWith("'");
    }

    private static boolean isMixedCased(String identifier) {
        boolean containsLowerCaseLetters = !identifier.equals(identifier.toUpperCase());
        boolean containsUpperCaseLetters = !identifier.equals(identifier.toLowerCase());
        return containsLowerCaseLetters && containsUpperCaseLetters;
    }
}

