/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.SpecItem;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.LinkRule;
import eu.cqse.check.wia.WorkItemCheckBase;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-wia-traceability-violation", languages={ELanguage.NL_TESTS, ELanguage.NL_REQUIREMENTS})
public class TraceabilityViolationCheck
extends WorkItemCheckBase<SpecItem> {
    private static final String CHECK_NAME = "Traceability Violation";
    @CheckOption(name="Traceability Violation - Required Link Rules", description="List of required link rules separated by comma or new-line.\nA single link rule has the format:\n\n`(<sourceItemTypes>) --[<relations>]-> (<targetItemTypes>)`\n\n`<sourceItemTypes>` is a `|` separated list of item types (or type abbreviations) the check matches on (e.g. `Test Case` or `TC`).\nAn empty list means that all items should be checked.\n\n`<relations>` is a `|` separated list of the required relation type between the source and target item (e.g. `Relates To`).\nAn empty list means that all relation types are accepted.\n\n`<targetItemTypes>` is a `|` separated list of item types (or type abbreviations) the relation must link to (e.g. `Epic`).\nAn empty list means that any target type would suffice.\n\nHere are some example rules:\n\n`() --[]-> ()` implies, that any item of any type must have a link of any type to another item of any type, i.e. every item should have a link to any other item.\n\n`(Test Case) --[Verifies|Tests]-> (Epic|Feature)` implies, that an item of type 'Test Case' must have at least one relation of type 'Verifies' or 'Tests' to an item of type 'Epic' or 'Feature'.\n\n`(Epic|Feature) --[Is Verified By|Is Tested By]-> (Test Case)` implies, that an item of type 'Epic' or 'Feature' must have a relation of type 'Is Verified By' or 'Is Tested By' to an item of type 'Test Case'.\n", multilineText=true)
    private Set<String> rawLinkRules = Collections.emptySet();
    private List<LinkRule> parsedLinkRules;

    public TraceabilityViolationCheck() {
        super(SpecItem.class);
    }

    public void initialize() throws CheckException {
        super.initialize();
        this.parsedLinkRules = LinkRule.parse(this.rawLinkRules);
    }

    @Override
    public void execute(SpecItem specItem) throws CheckException {
        for (LinkRule parsedRule : this.parsedLinkRules) {
            if (!parsedRule.isViolatedBy(specItem, this.context)) continue;
            FindingPropertyList properties = TraceabilityViolationCheck.buildProperties(parsedRule);
            this.buildFinding(parsedRule.buildFindingMessage(specItem), this.buildLocation().forWorkItem()).addFindingProperties(properties).createAndStore();
        }
    }

    private static @NonNull FindingPropertyList buildProperties(LinkRule parsedRule) {
        Function<Collection, String> typeConcatenation = elements -> {
            String input = String.join((CharSequence)", ", elements);
            return StringUtils.isEmptyOrElse((String)input, (String)"any");
        };
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Source Item Types", (Object)typeConcatenation.apply(parsedRule.getSourceItems()));
        properties.addProperty("Relations", (Object)typeConcatenation.apply(parsedRule.getRelations()));
        properties.addProperty("Target Item Types", (Object)typeConcatenation.apply(parsedRule.getTargetItems()));
        return properties;
    }
}

