/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser;

import com.teamscale.reportparser.CoverageReportParserBase;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class XcodeCoverageReportParser
extends CoverageReportParserBase {
    private static final Pattern SUBRANGE_LINE_PATTERN = Pattern.compile("^\\(\\d*,\\s\\d*,\\s(\\d*)\\)$");
    private static final String SUB_RANGE_BEGIN = "[";
    private static final String SUB_RANGE_END = "]";
    private static final String NOT_EXECUTABLE_INDICATOR = "*";
    private String currentFile = null;
    private long ignoredCompositeStatementsLineCount = 0L;
    private ELineCoverage coverageForCompositeStatement = null;
    private int compositeStatementLine = -1;

    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever retriever) {
        List reportLines = StringUtils.splitLinesAsList((String)report);
        for (String line : reportLines) {
            this.processReportLine(line, retriever);
        }
        this.possiblyLogAndResetIgnoredCompositeStatementsForFile();
    }

    private void processReportLine(String lineContent, CoverageInfoRetriever retriever) {
        if (StringUtils.isEmpty((String)lineContent)) {
            return;
        }
        Pair<Integer, String> pair = XcodeCoverageReportParser.parseExecutionLine(lineContent);
        if (pair != null) {
            this.processExecutionCountLine(lineContent, retriever, (Integer)pair.getFirst(), (String)pair.getSecond());
        } else if (lineContent.trim().equals(SUB_RANGE_END)) {
            this.processSubRangesEndLine(retriever);
        } else if (this.isInCompositeStatement()) {
            this.processSubRangeLine(lineContent);
        } else {
            this.possiblyLogAndResetIgnoredCompositeStatementsForFile();
            this.currentFile = StringUtils.stripSuffix((String)lineContent.trim(), (String)":");
            retriever.getOrCreateLineCoverageInfo(this.currentFile);
        }
    }

    private boolean isInCompositeStatement() {
        return this.compositeStatementLine != -1;
    }

    private void processSubRangeLine(String line) {
        Matcher subrangeMatcher = SUBRANGE_LINE_PATTERN.matcher(line);
        if (subrangeMatcher.matches()) {
            String executionCountString = subrangeMatcher.group(1);
            int subRangeExecutionCount = -1;
            try {
                subRangeExecutionCount = Integer.parseInt(executionCountString);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Expecting sub range execution count to be an Integer but got: {}", (Object)executionCountString);
            }
            if (subRangeExecutionCount == 0 && this.coverageForCompositeStatement == ELineCoverage.FULLY_COVERED) {
                this.coverageForCompositeStatement = ELineCoverage.PARTIALLY_COVERED;
            }
        } else {
            LOGGER.error("Invalid format for subrange line: {}", (Object)line);
        }
    }

    private void processExecutionCountLine(String lineContent, CoverageInfoRetriever retriever, int lineNumber, String executionCountString) {
        if (lineContent.endsWith(SUB_RANGE_BEGIN)) {
            this.compositeStatementLine = lineNumber;
        }
        if (executionCountString.equals(NOT_EXECUTABLE_INDICATOR)) {
            if (this.isInCompositeStatement()) {
                LOGGER.debug("Ignoring composite statement coverage information for line with 'not executable' indicator for line {} in file {}", (Object)lineNumber, (Object)this.currentFile);
                ++this.ignoredCompositeStatementsLineCount;
            }
            return;
        }
        long executionCount = XcodeCoverageReportParser.parseExecutionCount(executionCountString);
        ELineCoverage coverage = XcodeCoverageReportParser.getLineCoverage(executionCount);
        if (this.isInCompositeStatement()) {
            this.coverageForCompositeStatement = coverage;
        } else {
            retriever.getOrCreateLineCoverageInfo(this.currentFile).addLineCoverage(lineNumber, coverage);
        }
    }

    private void processSubRangesEndLine(CoverageInfoRetriever retriever) {
        if (this.coverageForCompositeStatement != null) {
            retriever.getOrCreateLineCoverageInfo(this.currentFile).addLineCoverage(this.compositeStatementLine, this.coverageForCompositeStatement);
        }
        this.compositeStatementLine = -1;
        this.coverageForCompositeStatement = null;
    }

    private void possiblyLogAndResetIgnoredCompositeStatementsForFile() {
        if (this.currentFile != null && this.ignoredCompositeStatementsLineCount > 0L) {
            LOGGER.warn("Ignoring composite statement coverage information for {} line(s) with 'not executable' indicator in file {}. More detailed information might be available at DEBUG level.", (Object)this.ignoredCompositeStatementsLineCount, (Object)this.currentFile);
            this.ignoredCompositeStatementsLineCount = 0L;
        }
    }

    private static ELineCoverage getLineCoverage(long executionCount) {
        if (executionCount > 0L) {
            return ELineCoverage.FULLY_COVERED;
        }
        return ELineCoverage.NOT_COVERED;
    }

    private static long parseExecutionCount(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Expecting execution count to be a Long but got: {}", (Object)value);
            return -1L;
        }
    }

    private static @Nullable Pair<Integer, String> parseExecutionLine(String lineContent) {
        lineContent = lineContent.trim();
        int colonIndex = lineContent.indexOf(58);
        if (lineContent.startsWith("/") || colonIndex == -1) {
            return null;
        }
        String lineNumberPart = lineContent.substring(0, colonIndex).trim();
        String executionCountPart = lineContent.substring(colonIndex + 1).trim();
        if (executionCountPart.endsWith(SUB_RANGE_BEGIN)) {
            executionCountPart = executionCountPart.substring(0, executionCountPart.length() - 1).trim();
        }
        try {
            int lineNumber = Integer.parseInt(lineNumberPart);
            return new Pair((Object)lineNumber, (Object)executionCountPart);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Expecting line number to be an Integer but got: {}", (Object)lineNumberPart);
            return null;
        }
    }
}

