/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.jlink;

import com.teamscale.reportparser.CoverageReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import com.teamscale.reportparser.parser.jlink.EJlinkCsvHeaderConstants;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Map;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ParseLong;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

public class JLinkCsvCoverageReportParser
extends CoverageReportParserBase {
    private static final CellProcessor[] SOURCE_LINE_PROCESSORS = new CellProcessor[]{new NotNull(), new ParseInt(), new NotNull(), new Optional(), new ParseLong(), new ParseLong(), new ParseLong(), new ParseLong(), new ParseLong()};
    private static final CellProcessor[] FUNCTION_PROCESSORS = new CellProcessor[]{new Optional(), new ParseInt(), new NotNull(), new ParseLong(), new ParseLong(), new ParseLong(), new ParseLong(), new ParseLong(), new ParseLong()};

    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever retriever) throws ReportParserException {
        StringReader stringReader = new StringReader(report);
        CsvMapReader csvReader = new CsvMapReader((Reader)stringReader, CsvPreference.STANDARD_PREFERENCE);
        try {
            Object[] header = csvReader.getHeader(true);
            String metadata = Arrays.toString(header);
            boolean isFunctionCoverage = false;
            EJlinkCsvHeaderConstants coverageKey = EJlinkCsvHeaderConstants.INSTRUCTIONS_COVERED;
            CellProcessor[] processors = SOURCE_LINE_PROCESSORS;
            if (!metadata.contains(EJlinkCsvHeaderConstants.INSTRUCTIONS_COVERED.getHeaderName()) && !metadata.contains(EJlinkCsvHeaderConstants.EXECUTABLE_SOURCE_LINES_COVERED.getHeaderName())) {
                LOGGER.error("Could not parse report in unsupported format. Teamscale can only parse Function and Source Line Ozone coverage reports.");
                return;
            }
            if (metadata.contains(EJlinkCsvHeaderConstants.EXECUTABLE_SOURCE_LINES_COVERED.getHeaderName())) {
                coverageKey = EJlinkCsvHeaderConstants.EXECUTABLE_SOURCE_LINES_COVERED;
                isFunctionCoverage = true;
                processors = FUNCTION_PROCESSORS;
            }
            JLinkCsvCoverageReportParser.parseCsv(csvReader, (String[])header, processors, coverageKey, retriever, isFunctionCoverage);
        }
        catch (IOException e) {
            LOGGER.error("Could not parse coverage report.");
            throw new ReportParserException(e);
        }
    }

    private static void parseCsv(CsvMapReader csvReader, String[] header, CellProcessor[] processors, EJlinkCsvHeaderConstants coverageKey, CoverageInfoRetriever retriever, boolean isFunctionCoverage) throws IOException {
        Map reportHeaderToCurrentCellValue;
        while ((reportHeaderToCurrentCellValue = csvReader.read(header, processors)) != null) {
            String path = (String)reportHeaderToCurrentCellValue.get(header[0]);
            if (path == null) {
                LOGGER.info("No path defined in current coverage line " + csvReader.getRowNumber() + ". Skipping.");
                continue;
            }
            int line = (Integer)reportHeaderToCurrentCellValue.get(header[1]);
            long executedLines = (Long)reportHeaderToCurrentCellValue.get(coverageKey.getHeaderName());
            ELineCoverage coverageType = ELineCoverage.NOT_COVERED;
            if (executedLines > 0L) {
                coverageType = ELineCoverage.FULLY_COVERED;
            }
            LineCoverageInfo coverageInfo = retriever.getOrCreateLineCoverageInfo(path);
            coverageInfo.addLineCoverage(line, coverageType);
            coverageInfo.setMethodAccurate(isFunctionCoverage);
        }
    }
}

