/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.comparison;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryExamples;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public final class FindingInstanceComparisonDiffEntry
extends InstanceComparisonDiffEntryBase<FindingsCount> {
    private static final long serialVersionUID = 1L;
    private static final String DETAILED_FINDINGS_DIFF_PROPERTY = "detailedFindingsDiff";
    @JsonProperty(value="detailedFindingsDiff")
    private final @Nullable DetailedFindingInstanceComparisonDiff detailedDiff;

    @JsonCreator
    public FindingInstanceComparisonDiffEntry(@JsonProperty(value="name") String name, @JsonProperty(value="localValue") @JsonAlias(value={"localFindingsCount"}) FindingsCount localValue, @JsonProperty(value="remoteValue") @JsonAlias(value={"remoteFindingsCount"}) FindingsCount remoteValue, @JsonProperty(value="detailedFindingsDiff") @Nullable DetailedFindingInstanceComparisonDiff detailedDiff, @JsonProperty(value="examples") InstanceComparisonDiffEntryExamples examples, @JsonProperty(value="withinAcceptedDeviations") boolean withinAcceptedDeviations) {
        super(name, examples, localValue, remoteValue, withinAcceptedDeviations);
        this.detailedDiff = detailedDiff;
    }

    public boolean hasRealDifference() {
        return !((FindingsCount)this.localValue).equals(this.remoteValue) || this.detailedDiff != null && this.detailedDiff.hasRealDifference() || !this.examples.getMissingRemote().isEmpty() || !this.examples.getMissingLocal().isEmpty();
    }

    @Override
    public boolean isOnlyImprovement() {
        boolean onlyImprovement;
        boolean bl = onlyImprovement = ((FindingsCount)this.localValue).normal() == ((FindingsCount)this.remoteValue).normal() && ((FindingsCount)this.localValue).tolerated() == ((FindingsCount)this.remoteValue).tolerated() && ((FindingsCount)this.localValue).falsePositive() < ((FindingsCount)this.remoteValue).falsePositive();
        if (this.detailedDiff != null) {
            onlyImprovement &= this.detailedDiff.newLocalFindings.isZero() && this.detailedDiff.disappearedRemoteFindings.normal == 0 && this.detailedDiff.disappearedRemoteFindings.tolerated == 0;
        }
        return onlyImprovement;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    @IndexValueClass
    public static class DetailedFindingInstanceComparisonDiff
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String NEW_LOCAL_FINDINGS_PROPERTY = "newLocalFindings";
        private static final String DISAPPEARED_REMOTE_FINDINGS_PROPERTY = "disappearedRemoteFindings";
        private static final String RELATIVE_CHANGE_FOR_CHECK_PROPERTY = "relativeChangeForCheck";
        private static final String INFLUENCE_ON_FINDINGS_DENSITY_PROPERTY = "influenceOnFindingsDensity";
        private static final String RELATIVE_CHANGE_FOR_ALL_FINDINGS_PROPERTY = "relativeChangeForAllFindings";
        @JsonProperty(value="newLocalFindings")
        public final FindingsCount newLocalFindings;
        @JsonProperty(value="disappearedRemoteFindings")
        public final FindingsCount disappearedRemoteFindings;
        @JsonProperty(value="relativeChangeForCheck")
        private final double relativeChangeForCheck;
        @JsonProperty(value="relativeChangeForAllFindings")
        private final double relativeChangeForAllFindings;
        @JsonProperty(value="influenceOnFindingsDensity")
        private final double influenceOnFindingsDensity;

        @JsonCreator
        public DetailedFindingInstanceComparisonDiff(@JsonProperty(value="newLocalFindings") FindingsCount newLocalFindings, @JsonProperty(value="disappearedRemoteFindings") FindingsCount disappearedRemoteFindings, @JsonProperty(value="relativeChangeForCheck") double relativeChangeForCheck, @JsonProperty(value="relativeChangeForAllFindings") double relativeChangeForAllFindings, @JsonProperty(value="influenceOnFindingsDensity") double influenceOnFindingsDensity) {
            this.newLocalFindings = newLocalFindings;
            this.disappearedRemoteFindings = disappearedRemoteFindings;
            this.relativeChangeForCheck = relativeChangeForCheck;
            this.relativeChangeForAllFindings = relativeChangeForAllFindings;
            this.influenceOnFindingsDensity = influenceOnFindingsDensity;
        }

        private boolean hasRealDifference() {
            return !this.newLocalFindings.isZero() || !this.disappearedRemoteFindings.isZero();
        }
    }

    @IndexValueClass
    public record FindingsCount(@JsonProperty(value="normal") int normal, @JsonProperty(value="tolerated") int tolerated, @JsonProperty(value="falsePositive") int falsePositive) implements Serializable
    {
        @Override
        public String toString() {
            if (this.tolerated > 0 || this.falsePositive > 0) {
                return "%d (%d tolerated, %d false positives)".formatted(this.normal, this.tolerated, this.falsePositive);
            }
            return String.valueOf(this.normal);
        }

        public boolean isZero() {
            return this.normal == 0 && this.tolerated == 0 && this.falsePositive == 0;
        }
    }
}

