/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.comparison;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class InstanceComparisonDiffEntryExamples
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_EXAMPLE_COUNT = 10;
    private static final String MISSING_LOCAL_PROPERTY = "missingLocal";
    private static final String MISSING_REMOTE_PROPERTY = "missingRemote";
    public static final InstanceComparisonDiffEntryExamples EMPTY = new InstanceComparisonDiffEntryExamples(Collections.emptyList(), Collections.emptyList());
    private final List<DetailedInstanceComparisonValue> missingLocal;
    private final List<DetailedInstanceComparisonValue> missingRemote;

    public InstanceComparisonDiffEntryExamples() {
        this.missingLocal = new ArrayList<DetailedInstanceComparisonValue>();
        this.missingRemote = new ArrayList<DetailedInstanceComparisonValue>();
    }

    @JsonCreator
    InstanceComparisonDiffEntryExamples(@JsonProperty(value="missingLocal") List<DetailedInstanceComparisonValue> missingLocal, @JsonProperty(value="missingRemote") List<DetailedInstanceComparisonValue> missingRemote) {
        this.missingLocal = missingLocal;
        this.missingRemote = missingRemote;
    }

    public void addMissingLocal(@Nullable DetailedInstanceComparisonValue local) {
        if (local != null) {
            this.missingLocal.add(local);
        }
    }

    @JsonGetter(value="missingLocal")
    List<DetailedInstanceComparisonValue> getMissingLocalPortion() {
        return this.missingLocal.subList(0, Math.min(this.missingLocal.size(), 10));
    }

    public UnmodifiableList<DetailedInstanceComparisonValue> getMissingLocal() {
        return CollectionUtils.asUnmodifiable(this.missingLocal);
    }

    public void addMissingRemote(@Nullable DetailedInstanceComparisonValue remote) {
        if (remote != null) {
            this.missingRemote.add(remote);
        }
    }

    @JsonGetter(value="missingRemote")
    List<DetailedInstanceComparisonValue> getMissingRemotePortion() {
        return this.missingRemote.subList(0, Math.min(this.missingRemote.size(), 10));
    }

    public UnmodifiableList<DetailedInstanceComparisonValue> getMissingRemote() {
        return CollectionUtils.asUnmodifiable(this.missingRemote);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceComparisonDiffEntryExamples that = (InstanceComparisonDiffEntryExamples)o;
        return this.missingLocal.equals(that.missingLocal) && this.missingRemote.equals(that.missingRemote);
    }

    public int hashCode() {
        return Objects.hash(this.missingLocal, this.missingRemote);
    }
}

