/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot;

import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotMetaData;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributionBase;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;

@Index(name="instance-comparison-snapshot-creation", options={EStorageOption.COMPRESSED}, valueClasses={InstanceComparisonSnapshotMetaData.class, InstanceComparisonContributionBase.class})
public class InstanceComparisonSnapshotCreationIndex
implements IGlobalIndex {
    public static final String NAME = "instance-comparison-snapshot-creation";
    private static final String DELIMITER = "|";
    private final ConvenientStore metadataStore;
    private final ConvenientStore contributionStore;

    public InstanceComparisonSnapshotCreationIndex(IStore store) {
        this.metadataStore = new ConvenientStore((IStore)new DelegatingPartitionStore(store, "metadata"));
        this.contributionStore = new ConvenientStore((IStore)new DelegatingPartitionStore(store, "contributions"));
    }

    public void storeSnapshotMetaData(InstanceComparisonSnapshotMetaData metaData) throws StorageException {
        this.metadataStore.putWithString(metaData.getId(), StorageUtils.serialize((Serializable)metaData));
    }

    public Optional<InstanceComparisonSnapshotMetaData> getSnapshotMetaData(String id) throws StorageException {
        return Optional.ofNullable((InstanceComparisonSnapshotMetaData)StorageUtils.deserialize((byte[])this.metadataStore.getWithString(id)));
    }

    public List<InstanceComparisonSnapshotMetaData> getSnapshotMetaDataByPrefix(String idPrefix) throws StorageException {
        return InstanceComparisonSnapshotCreationIndex.getAllByPrefix(this.metadataStore, idPrefix);
    }

    public List<InstanceComparisonSnapshotMetaData> getAllSnapshotsMetaData() throws StorageException {
        return this.getSnapshotMetaDataByPrefix("");
    }

    public void removeSnapshot(String snapshotId) throws StorageException {
        this.metadataStore.removeWithString(snapshotId);
        this.contributionStore.removeByPrefix(snapshotId + DELIMITER);
    }

    public void storeSnapshotContribution(String snapshotId, InstanceComparisonContributionBase contribution) throws StorageException {
        this.contributionStore.putWithString(InstanceComparisonSnapshotCreationIndex.makeContributionKey(snapshotId, contribution), StorageUtils.serialize((Serializable)contribution));
    }

    public List<InstanceComparisonContributionBase> getAllSnapshotContributions(String snapshotId) throws StorageException {
        return InstanceComparisonSnapshotCreationIndex.getAllByPrefix(this.contributionStore, snapshotId + DELIMITER);
    }

    private static <T extends Serializable> List<T> getAllByPrefix(ConvenientStore store, String prefix) throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        store.scan(prefix, (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    private static String makeContributionKey(String snapshotId, InstanceComparisonContributionBase contribution) {
        String projectId = null;
        if (contribution instanceof ProjectComparisonContributionBase) {
            ProjectComparisonContributionBase projectContribution = (ProjectComparisonContributionBase)contribution;
            projectId = projectContribution.getProject();
        }
        return InstanceComparisonSnapshotCreationIndex.makeContributionKey(snapshotId, projectId, contribution.getContributor());
    }

    private static String makeContributionKey(String snapshotId, @Nullable String projectId, String contributor) {
        return String.join((CharSequence)DELIMITER, snapshotId, projectId, contributor);
    }
}

