/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions;

import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryExamples;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import java.util.Optional;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface IInstanceComparisonValue {
    public static InstanceComparisonDiffEntryExamples computeExamples(String key, @Nullable IInstanceComparisonValue local, @Nullable IInstanceComparisonValue remote) {
        Predicate<IInstanceComparisonValue> isDetailImplemented = icv -> icv == null || icv.getDetails() != null;
        if (!isDetailImplemented.test(local) || !isDetailImplemented.test(remote)) {
            return InstanceComparisonDiffEntryExamples.EMPTY;
        }
        return IDetailedInstanceComparisonContribution.computeExamples(key, Optional.ofNullable(local).map(IInstanceComparisonValue::getDetails).orElse(null), Optional.ofNullable(remote).map(IInstanceComparisonValue::getDetails).orElse(null));
    }

    public static boolean isWithinAcceptedDeviation(double localValue, double remoteValue, double acceptedDeviation) {
        return localValue >= (1.0 - acceptedDeviation) * remoteValue && localValue <= (1.0 + acceptedDeviation) * remoteValue;
    }

    public Optional<? extends InstanceComparisonDiffEntryBase<?>> computeDifference(@Nullable IInstanceComparisonValue var1, boolean var2, InstanceComparisonContributionBase.ComparisonContext var3);

    public @Nullable IDetailedInstanceComparisonContribution getDetails();

    public String getValueHumanReadable();
}

