/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.util.MetricValueUtils;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class MetricsComparisonContribution
extends ProjectComparisonContributionBase {
    private static final long serialVersionUID = 1L;
    private static final String SCHEMA_PROPERTY = "schema";
    private static final String ENTRY_PROPERTY = "entry";
    @JsonProperty(value="schema")
    private final MetricDirectorySchema schema;
    @JsonProperty(value="entry")
    private final @Nullable MetricDirectoryEntry entry;

    @JsonCreator
    public MetricsComparisonContribution(@JsonProperty(value="contributor") String contributor, @JsonProperty(value="project") String project, @JsonProperty(value="schema") MetricDirectorySchema schema, @JsonProperty(value="entry") @Nullable MetricDirectoryEntry entry) {
        super(contributor, project);
        this.schema = schema;
        this.entry = entry;
    }

    @Override
    public Map<String, ? extends IInstanceComparisonValue> getValues(InstanceComparisonContributionBase.ComparisonContext context) {
        HashMap<String, IInstanceComparisonValue> result = new HashMap<String, IInstanceComparisonValue>();
        for (int i = 0; i < this.schema.size(); ++i) {
            String metricName = this.schema.getEntry(i).getName();
            if (MetricsComparisonContribution.isIgnored(metricName)) continue;
            result.put(metricName, MetricValueUtils.getComparisonValueForMetric(metricName, this.entry, i));
        }
        return result;
    }

    private static boolean isIgnored(String metricName) {
        return metricName.equals("Change Count") || metricName.equals("Last Change Date") || metricName.startsWith("Number of Findings") || metricName.startsWith("Findings Density");
    }

    MetricDirectorySchema getSchema() {
        return this.schema;
    }

    @Nullable MetricDirectoryEntry getEntry() {
        return this.entry;
    }
}

