/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ILogErrorsComparisonDetailContribution;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeName(value="parse")
@IndexValueClass
class ParseLogErrorsComparisonDetailContribution
implements ILogErrorsComparisonDetailContribution {
    private static final long serialVersionUID = 1L;
    private static final String LOG_ENTRIES_FOR_UNIFORM_PATH_PROPERTY = "entriesForUniformPath";
    @JsonProperty(value="entriesForUniformPath")
    private final @NonNull Map<String, Set<LogEntry>> logErrorEntriesForUniformPath;

    @JsonCreator
    ParseLogErrorsComparisonDetailContribution(@JsonProperty(value="entriesForUniformPath") @NonNull Map<String, Set<LogEntry>> logErrorEntriesForUniformPath) {
        CCSMAssert.isNotNull(logErrorEntriesForUniformPath, () -> String.format("Expected \"%s\" to be not null", LOG_ENTRIES_FOR_UNIFORM_PATH_PROPERTY));
        this.logErrorEntriesForUniformPath = logErrorEntriesForUniformPath;
    }

    public ParseLogErrorsComparisonDetailContribution() {
        this.logErrorEntriesForUniformPath = new HashMap<String, Set<LogEntry>>();
    }

    public void add(ParseLogEntry logEntry) {
        this.logErrorEntriesForUniformPath.computeIfAbsent(logEntry.getUniformPath(), ignored -> new HashSet()).add(new LogEntry(logEntry));
    }

    @Override
    public @NonNull Map<String, DetailedInstanceComparisonValue> getDetailedValues(String uniformPath) {
        Function<LogEntry, String> keyMapper = logEntry -> logEntry.getCommit().toString() + "|" + logEntry.getLineNumber();
        Function<LogEntry, DetailedInstanceComparisonValue> valueMapper = logEntry -> DetailedInstanceComparisonValue.ofParserLogError(new DetailedInstanceComparisonValue.ParserLogId(uniformPath, logEntry.getLineNumber(), logEntry.getCommit()));
        return this.logErrorEntriesForUniformPath.getOrDefault(uniformPath, Collections.emptySet()).stream().collect(Collectors.toMap(keyMapper, valueMapper, CollectionUtils.throwingMerger(DetailedInstanceComparisonValue::getHumanReadable), TreeMap::new));
    }

    @IndexValueClass
    private static class LogEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String COMMIT_PROPERTY = "commit";
        private static final String LINE_NUMBER_PROPERTY = "lineNumber";
        @JsonProperty(value="commit")
        private final CommitDescriptor commit;
        @JsonProperty(value="lineNumber")
        private final int lineNumber;

        private LogEntry(ParseLogEntry logEntry) {
            this.commit = new CommitDescriptor(logEntry.getCommit());
            this.lineNumber = logEntry.getLineNumber();
        }

        @JsonCreator
        LogEntry(@JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="lineNumber") int lineNumber) {
            this.commit = commit;
            this.lineNumber = lineNumber;
        }

        private CommitDescriptor getCommit() {
            return this.commit;
        }

        private int getLineNumber() {
            return this.lineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogEntry logEntry = (LogEntry)o;
            return this.lineNumber == logEntry.lineNumber && Objects.equals(this.commit, logEntry.commit);
        }

        public int hashCode() {
            return Objects.hash(this.commit, this.lineNumber);
        }
    }
}

