/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.profiler;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.index.admin.profiler.RunningProfilerInfo;
import com.teamscale.index.admin.profiler.RunningProfilersIndex;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.VisibleForTesting;

@PeriodicMaintenanceJob(cronExpression="0 * * * *")
public class RunningProfilerCleanupTrigger
extends MaintenanceTriggerBase {
    private static final int MAX_TERMINATED_PROFILER_RUNS_TO_KEEP = 100;

    public void execute() throws Exception {
        RunningProfilersIndex runningProfilersIndex = (RunningProfilersIndex)this.indexLayer.openGlobalIndex(RunningProfilersIndex.class);
        RunningProfilerCleanupTrigger.removeShutDownProfilers(runningProfilersIndex);
    }

    @VisibleForTesting
    static void removeShutDownProfilers(RunningProfilersIndex runningProfilersIndex) throws StorageException {
        List<RunningProfilerInfo> allTerminatedProfilerRuns = runningProfilersIndex.getAllProfilerRuns().stream().filter(RunningProfilerInfo::hasShutDown).sorted(Comparator.comparingLong(RunningProfilerInfo::lastHeartbeatTimestamp)).toList();
        if (allTerminatedProfilerRuns.size() > 100) {
            List<RunningProfilerInfo> toRemove = allTerminatedProfilerRuns.subList(100, allTerminatedProfilerRuns.size());
            runningProfilersIndex.removeProfilerInfos(toRemove.stream().map(RunningProfilerInfo::id).toList());
        }
    }
}

