/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.assessment;

import com.teamscale.index.architecture.assessment.SubsumedDependencyInfo;
import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.commons.EPolicyType;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jetbrains.annotations.VisibleForTesting;

public class ArchitectureAssessor {
    private final ArchitectureDefinition architecture;
    private final TypeComponentMapping metaInfo;
    private final TwoDimHashMap<ComponentNode, ComponentNode, Dependency> dependenciesBySourceAndTarget = new TwoDimHashMap();
    private final List<SubsumedDependencyInfo> subsumedDependencyInfos = new ArrayList<SubsumedDependencyInfo>();
    private final SetMap<String, String> typeDependencies;
    private final SetMap<ComponentNode, ComponentNode> componentDependencies = new SetMap();
    private final Set<ComponentNode> seenComponents = new HashSet<ComponentNode>();

    public ArchitectureAssessor(ArchitectureDefinition architecture, SetMap<String, String> typeDependencies, TypeComponentMapping metaInfo) {
        this.architecture = architecture;
        this.typeDependencies = typeDependencies;
        this.metaInfo = metaInfo;
        this.calculateDependencies();
    }

    public UnmodifiableList<Dependency> getAllDependencies() {
        return CollectionUtils.asUnmodifiable((List)this.dependenciesBySourceAndTarget.getValues());
    }

    @VisibleForTesting
    public Set<String> getMappedTypes(ComponentNode component) {
        return this.metaInfo.getMappedTypes(component);
    }

    private @Nullable ComponentNode getMappedComponentForType(String type) {
        String componentName = this.metaInfo.getMappedComponentForType(type);
        return this.architecture.getComponentByName(componentName);
    }

    private void calculateDependencies() {
        this.loadDependenciesFromSpecifiedArchitecture();
        this.loadDependenciesFromImplementation();
        for (ComponentNode source : this.dependenciesBySourceAndTarget.getFirstKeys()) {
            this.addTypeDependencies(source);
        }
        for (SubsumedDependencyInfo subsumedDependencyInfo : this.subsumedDependencyInfos) {
            this.addTypeDependencies(subsumedDependencyInfo);
        }
    }

    private void addTypeDependencies(SubsumedDependencyInfo subsumedDependencyInfo) {
        for (String fromType : this.getMappedTypes(subsumedDependencyInfo.subsumedSource())) {
            Set toTypes = (Set)this.typeDependencies.getCollectionOrEmpty((Object)fromType);
            for (String toType : toTypes) {
                Dependency dependency;
                if (!this.typeBelongsToComponents(toType, subsumedDependencyInfo.subsumedTarget(), subsumedDependencyInfo.subsumingTarget()) || (dependency = (Dependency)this.dependenciesBySourceAndTarget.getValue((Object)subsumedDependencyInfo.subsumingSource(), (Object)subsumedDependencyInfo.subsumingTarget())) == null) continue;
                TypeDependency typeDependency = new TypeDependency(fromType, toType);
                dependency.addTypeDependency(typeDependency);
            }
        }
    }

    private boolean typeBelongsToComponents(String type, ComponentNode component1, ComponentNode component2) {
        ComponentNode component = this.getMappedComponentForType(type);
        return component1.equals(component) || component2.equals(component);
    }

    private void addTypeDependencies(ComponentNode sourceComponent) {
        boolean newlySeenComponent = this.seenComponents.add(sourceComponent);
        if (!newlySeenComponent) {
            return;
        }
        for (String fromType : this.getMappedTypes(sourceComponent)) {
            Set toTypes = (Set)this.typeDependencies.getCollectionOrEmpty((Object)fromType);
            for (String toType : toTypes) {
                ComponentNode targetComponent = this.getMappedComponentForType(toType);
                Dependency value = (Dependency)this.dependenciesBySourceAndTarget.getValue((Object)sourceComponent, (Object)targetComponent);
                if (value == null) continue;
                value.addTypeDependency(new TypeDependency(fromType, toType));
            }
        }
        for (ComponentNode sourceChild : sourceComponent.getSubComponents()) {
            this.addTypeDependencies(sourceChild);
        }
    }

    private void loadDependenciesFromSpecifiedArchitecture() {
        for (Dependency dependency : this.architecture.getAllPolicies()) {
            Dependency dependency2 = new Dependency(dependency.getSource(), dependency.getTarget());
            this.dependenciesBySourceAndTarget.putValue((Object)dependency2.getSource(), (Object)dependency2.getTarget(), (Object)dependency2);
            this.componentDependencies.add((Object)dependency.getSource(), (Object)dependency.getTarget());
            if (dependency.getType() != EPolicyType.TOLERATE_EXPLICIT) continue;
            for (TypeDependency typeDependency : dependency.getToleratedDependencies()) {
                dependency2.addToleratedTypeDependency(new TypeDependency(typeDependency.getSource(), typeDependency.getTarget()));
            }
        }
    }

    private void loadDependenciesFromImplementation() {
        SetMap rawComponentDependencies = new SetMap();
        for (Map.Entry sourceEntry : this.typeDependencies.entrySet()) {
            ComponentNode source = this.getMappedComponentForType((String)sourceEntry.getKey());
            if (source == null) continue;
            for (String targetType : (Set)sourceEntry.getValue()) {
                ComponentNode target = this.getMappedComponentForType(targetType);
                if (target == null) continue;
                rawComponentDependencies.add((Object)source, (Object)target);
            }
        }
        List<Dependency> sortedDependenciesFromSpecification = this.getSortedDependencies();
        for (Map.Entry sourceEntry : rawComponentDependencies.entrySet()) {
            ComponentNode source = (ComponentNode)sourceEntry.getKey();
            for (ComponentNode target : (Set)sourceEntry.getValue()) {
                if (target.isDescendant(source) || source.isDescendant(target) || this.isSubsumedByOtherDependency(source, target, sortedDependenciesFromSpecification)) continue;
                this.dependenciesBySourceAndTarget.putValue((Object)source, (Object)target, (Object)new Dependency(source, target));
                this.componentDependencies.add((Object)source, (Object)target);
            }
        }
    }

    private boolean isSubsumedByOtherDependency(ComponentNode source, ComponentNode target, List<Dependency> sortedDependenciesFromSpecification) {
        Set<ComponentNode> sourceAncestors = source.getAncestors();
        Set<ComponentNode> targetAncestors = target.getAncestors();
        for (Dependency dependency : sortedDependenciesFromSpecification) {
            Optional<SubsumedDependencyInfo> subsumedDependencyInfo = ArchitectureAssessor.getSubsumedByDependency(sourceAncestors, targetAncestors, dependency, source, target);
            if (!subsumedDependencyInfo.isPresent()) continue;
            this.subsumedDependencyInfos.add(subsumedDependencyInfo.get());
            return true;
        }
        return false;
    }

    private List<Dependency> getSortedDependencies() {
        List dependencies = this.dependenciesBySourceAndTarget.getValues();
        dependencies.sort(Comparator.comparingInt(d -> d.getSource().getAncestors().size()).thenComparing(d -> d.getTarget().getAncestors().size()).reversed());
        return dependencies;
    }

    private static Optional<SubsumedDependencyInfo> getSubsumedByDependency(Set<ComponentNode> sourceAncestors, Set<ComponentNode> targetAncestors, Dependency dependency, ComponentNode source, ComponentNode target) {
        if (dependency.getType() == EPolicyType.ALLOW_IMPLICIT || dependency.getType() == EPolicyType.DENY_IMPLICIT) {
            return Optional.empty();
        }
        ComponentNode dependencySource = dependency.getSource();
        ComponentNode dependencyTarget = dependency.getTarget();
        for (ComponentNode sourceAncestor : sourceAncestors) {
            if (!dependencySource.equals(sourceAncestor)) continue;
            for (ComponentNode targetAncestor : targetAncestors) {
                if (!dependencyTarget.equals(targetAncestor)) continue;
                return Optional.of(new SubsumedDependencyInfo(source, target, sourceAncestor, targetAncestor));
            }
        }
        return Optional.empty();
    }
}

