/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.audit.checks;

import eu.cqse.check.base.ThrowExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;

@Check(name="Throw of specific exception in CS and VB", groupName="Exception Handling", defaultEnablement=EFindingEnablement.OFF, languages={ELanguage.CS, ELanguage.VB}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ThrowSpecificExceptionsCSAndVBCheck
extends ThrowExceptionCheckBase {
    protected String getFindingMessage(List<IToken> tokens) {
        return "Throw of specific exception ";
    }

    public boolean skipMethod(ShallowEntity entity) {
        return false;
    }

    public boolean createFindingForException(List<IToken> tokens, String exceptionClassName) {
        return !LanguageFeatureParser.CS.isGenericExceptionClass(exceptionClassName);
    }
}

