/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.backup.AutoBackupOption;
import com.teamscale.index.backup.BackupCleaner;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.BackupTargetFactory;
import com.teamscale.index.backup.IBackupTarget;
import com.teamscale.index.backup.TemporaryFileIndex;
import com.teamscale.index.backup.write.BackupExportOptions;
import com.teamscale.index.backup.write.BackupExportStatus;
import com.teamscale.index.backup.write.BackupWriter;
import com.teamscale.index.backup.write.BackupWritingParameters;
import io.prometheus.metrics.core.metrics.Counter;
import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;

public class AutoBackupTrigger
extends OptionScheduledTriggerBase {
    private static final Counter AUTO_BACKUP_RUNS_COUNTER = (Counter)((Counter.Builder)Counter.builder().help("Number of times the AutoBackupTrigger has run.")).name("auto_backup_total").register();
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException {
        if (EFeatureToggle.ENABLE_TEST_MODE.isEnabled()) {
            LOGGER.info("Skipping " + ((Object)((Object)this)).getClass().getSimpleName() + " as test mode is enabled");
            return;
        }
        AutoBackupOption option = (AutoBackupOption)this.getTriggeringOption(AutoBackupOption.class);
        BackupLocationInfo backupLocationInfo = new BackupLocationInfo(this.instanceConfiguration, option.getStorageLocation(), ZonedDateTime.now());
        try {
            IBackupTarget target = this.getBackupTarget(backupLocationInfo);
            BackupExportOptions exportOptions = new BackupExportOptions().setExportGlobalData(true).setIncludeAllProjects(true);
            new BackupWriter(new BackupWritingParameters(exportOptions, this.indexLayer, this.lockProvider, (File)this.getTemporaryDirectory(), this.instanceConfiguration), (ICancelable)this).writeBackupZip(target.getOutputStream(), new BackupExportStatus(exportOptions));
            target.completeBackup();
            if (option.isBackupCleanupActive()) {
                new BackupCleaner(option, ZonedDateTime.now(), ZoneId.systemDefault()).cleanupBackups(backupLocationInfo, target);
            }
            AUTO_BACKUP_RUNS_COUNTER.inc();
        }
        catch (IOException | ExecutionCanceledException | ConQATException e) {
            LOGGER.error("Failed to create backup file " + String.valueOf(backupLocationInfo) + ": " + e.getMessage(), e);
        }
    }

    private @NonNull IBackupTarget getBackupTarget(BackupLocationInfo backupLocationInfo) throws StorageException {
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        TemporaryFileIndex fileIndex = (TemporaryFileIndex)this.indexLayer.openGlobalIndex(TemporaryFileIndex.class);
        return BackupTargetFactory.getWriteTarget(backupLocationInfo.getOutputUri(), externalCredentialsIndex, fileIndex, LOGGER);
    }

    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }
}

