/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.index.backup.BackupInfo;
import com.teamscale.index.backup.BackupLocationInfo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public interface IBackupTarget {
    public static final String ZIP_FILE_EXTENSION = ".zip";

    public @Nullable String validate();

    public OutputStream getOutputStream() throws IOException;

    public SeekableByteChannel getReadChannel() throws IOException;

    public void deleteBackupFile() throws IOException;

    public Optional<File> getLocalFile();

    public List<BackupInfo> getBackupsInSameLocation(BackupLocationInfo var1) throws IOException;

    public void deleteBackupsInSameLocation(List<BackupInfo> var1) throws IOException;

    public static File getTemporaryFile(String fileExtension) throws IOException {
        return File.createTempFile("tempBackup", fileExtension, FileSystemUtils.getTmpDir());
    }

    default public void completeBackup() throws IOException {
    }
}

