/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.CommentAnalysisBase;
import com.teamscale.index.comment_analysis.CommentClassificationCache;
import com.teamscale.index.comment_analysis.ECommentCategory;
import com.teamscale.index.comment_analysis.classification.CppCommentClassifier;
import com.teamscale.index.comment_analysis.classification.CsCommentClassifier;
import com.teamscale.index.comment_analysis.classification.ICommentClassifier;
import com.teamscale.index.comment_analysis.classification.JavaCommentClassifier;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.string.LineOffsetConverter;

public abstract class CommentClassificationAnalysisBase
extends CommentAnalysisBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<ELanguage, ICommentClassifier> CLASSIFIERS = new HashMap<ELanguage, ICommentClassifier>();
    protected LineOffsetConverter rawLineOffsetConverter;
    protected StringOffsetTransformer offsetTransformer;

    public static boolean isSupportedLanguage(ELanguage language) {
        return CLASSIFIERS.containsKey(language);
    }

    public static boolean isSupportedLanguage(String language) {
        try {
            return CLASSIFIERS.containsKey(ELanguage.valueOf((String)language));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Set<ELanguage> getSupportedLanguages() {
        return Collections.unmodifiableSet(CLASSIFIERS.keySet());
    }

    public static ICommentClassifier getCommentClassifier(ELanguage language) {
        return CLASSIFIERS.get(language);
    }

    @Override
    protected void analyzeComments(List<Comment> comments, TokenElementInfo element, List<IToken> tokens, CommentClassificationCache classificationCache) throws ConQATException {
        this.rawLineOffsetConverter = new LineOffsetConverter(element.getText());
        this.offsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
        ELanguage language = element.getLanguage();
        if (!CommentClassificationAnalysisBase.isSupportedLanguage(language)) {
            LOGGER.warn("Unsupported language for comment classification: {}", (Object)language);
            return;
        }
        for (Comment comment : comments) {
            this.analyzeComment(comment, classificationCache.classifyComment(CLASSIFIERS.get(language), comment));
        }
    }

    protected abstract void analyzeComment(Comment var1, ECommentCategory var2) throws ConQATException;

    static {
        CLASSIFIERS.put(ELanguage.JAVA, new JavaCommentClassifier());
        CLASSIFIERS.put(ELanguage.CPP, new CppCommentClassifier());
        CLASSIFIERS.put(ELanguage.CPP_MS_CLI, new CppCommentClassifier());
        CLASSIFIERS.put(ELanguage.C, new CppCommentClassifier());
        CLASSIFIERS.put(ELanguage.CS, new CsCommentClassifier());
    }
}

