/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.ServiceUtils;
import java.io.Serializable;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ExternalAnalysisGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String GROUP_NAME_PROPERTY = "groupName";
    private static final String MAPPING_PROPERTY = "mapping";
    @JsonProperty(value="groupName")
    private final String groupName;
    @JsonProperty(value="mapping")
    private final String mapping;
    private transient @Nullable Pattern compiledMapping;

    @JsonCreator
    public ExternalAnalysisGroup(@JsonProperty(value="groupName") String groupName, @JsonProperty(value="mapping") String mapping) {
        this.groupName = groupName;
        this.mapping = mapping;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getMapping() {
        return this.mapping;
    }

    public boolean contains(String findingId) {
        if (this.compiledMapping == null) {
            this.compiledMapping = Pattern.compile(this.mapping);
        }
        return this.compiledMapping.matcher(findingId).matches();
    }

    public int hashCode() {
        return this.groupName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExternalAnalysisGroup)) {
            return false;
        }
        ExternalAnalysisGroup other = (ExternalAnalysisGroup)obj;
        return other.groupName.equals(this.groupName);
    }

    public Optional<String> validateIdentifiers() {
        StringJoiner errorMessageJoiner = new StringJoiner(", ");
        ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.getGroupName(), (String)"Group name").ifPresent(errorMessageJoiner::add);
        ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.getMapping(), (String)"Mapping pattern").ifPresent(errorMessageJoiner::add);
        if (errorMessageJoiner.length() > 0) {
            return Optional.of(errorMessageJoiner.toString());
        }
        return Optional.empty();
    }
}

