/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.metadata.MetaDataMetricSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;

public class FileMetadataConfiguration
extends AnalysisConfigurationBase {
    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.registerAbapMetrics(proxy.getCodeMetricSchema());
        proxy.createTrigger(new TriggerBuilder(MetaDataMetricSynchronizer.class, ETriggerConcurrency.PARALLEL));
    }

    private void registerAbapMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric("creationDate", schema.createMetricIndexSource("creationDate"), "Creation Date", "Creation date of the file", EMetricValueType.TIMESTAMP, MetricDirectorySchemaEntry.EAggregation.MIN, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("lastUpdateDateTime", schema.createMetricIndexSource("lastUpdateDateTime"), "Latest Update", "The latest time the file got updated", EMetricValueType.TIMESTAMP, MetricDirectorySchemaEntry.EAggregation.MAX, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("originatingSystem", schema.createMetricIndexSource("originatingSystem"), "Originating System", "The originating system of the file", EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("programType", schema.createMetricIndexSource("programType"), "Program Type", "The program type of the file", EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("languageVersion", schema.createMetricIndexSource("languageVersion"), "Language Version", "The language version of the file", EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("authorizationGroup", schema.createMetricIndexSource("authorizationGroup"), "Authorization Group", "The authorization group of the file", EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }
}

