/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.IndexBasedAnalysisConstants;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.findings.metrics.EFindingsMetricCategory;
import com.teamscale.core.metrics.AssessedRange;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.runtime.impl.analysis.CoreConfiguration;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.structure.StructuringAnalysis;
import com.teamscale.index.structure.metrics.FindingsDensityForSingleCategoryMetric;
import com.teamscale.index.structure.metrics.FindingsDensityMetric;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class StructuringConfiguration
extends AnalysisConfigurationBase {
    public static final String METRIC_VIOLATIONS_FINDINGS_CATEGORY = "Metric Violations";
    public static final String NESTING_DEPTH_FINDING_GROUP = "Nesting Depth";
    public static final String NESTING_DEPTH_TYPE_ID = IndexFinding.makeFindingTypeId((String)"Metric Violations", (String)"Nesting Depth");
    public static final String METHOD_LENGTH_FINDING_GROUP = "LSL";
    public static final String METHOD_LENGTH_TYPE_ID = IndexFinding.makeFindingTypeId((String)"Metric Violations", (String)"LSL");
    public static final String CYCLOMATIC_COMPLEXITY_FINDING_GROUP = "Cyclomatic Complexity";
    public static final String COMPLEXITY_TYPE_ID = IndexFinding.makeFindingTypeId((String)"Metric Violations", (String)"Cyclomatic Complexity");
    public static final String DISABLE_LOC_METRICS_CONFIG_NAME = "Disable LOC metrics";
    public static final String LINES_OF_CODE_METRIC = "loc";
    public static final String LINES_OF_CODE_METRIC_NAME = "Lines of Code";
    public static final String SOURCE_LINES_OF_CODE_METRIC = "sloc";
    public static final String SOURCE_LINES_OF_CODE_METRIC_NAME = "Source Lines of Code";
    public static final String FILES_METRIC = "files";
    public static final String FILES_METRIC_NAME = "Files";
    private static final String LANGUAGE_METRIC = "language";
    public static final String LANGUAGE_METRIC_NAME = "Language";
    public static final String LONGEST_METHOD_LENGTH_METRIC = "lsl";
    public static final String LONGEST_METHOD_LENGTH_METRIC_NAME = "Longest Method Length";
    public static final String MAXIMUM_NESTING_DEPTH_METRIC = "nesting";
    public static final String MAXIMUM_NESTING_DEPTH_METRIC_NAME = "Maximum Nesting Depth";
    public static final String MAXIMUM_CYCLOMATIC_COMPLEXITY_METRIC = "complexity";
    public static final String MAXIMUM_CYCLOMATIC_COMPLEXITY_METRIC_NAME = "Maximum Cyclomatic Complexity";
    public static final String FILE_SIZE_ASSESSMENT_METRIC_NAME = "File Size Assessment";
    public static final String METHOD_LENGTH_ASSESSMENT_METRIC_NAME = "Method Length Assessment";
    public static final String NESTING_DEPTH_ASSESSMENT_METRIC_NAME = "Nesting Depth Assessment";
    public static final String CYCLOMATIC_COMPLEXITY_ASSESSMENT_METRIC_NAME = "Cyclomatic Complexity Assessment";
    public static final String CODE_SCOPE_METRIC = "code-scope";
    public static final String NESTING_DEPTH_ASSESSMENT_PARTITION = "nesting-method-assessment";
    public static final String COMPLEXITY_ASSESSMENT_PARTITION = "complexity-method-assessment";
    public static final String METHOD_LENGTH_ASSESSMENT_PARTITION = "lsl-method-assessment";
    @ConfigExposed(name="Disable LOC metrics", description="Disables calculation of LOC and SLOC.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    @VisibleForTesting
    public CodeScopeAware<Boolean> disableLocMetrics = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="SLOC-Based", description="Measure file size in SLOC instead of LOC.")
    private CodeScopeAware<Boolean> fileSizeSLOCBased = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @ConfigExposed(name="Thresholds", description="Thresholds for file size.")
    private CodeScopeAware<NumericThresholds> fileSizeThresholds = CodeScopeAware.defaultCodeScopeWithValue((Object)new NumericThresholds(300, 750));
    private final CodeScopeAware<MetricDescriptor> fileSizeAssessmentMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("File Size Assessment", "Assessment metric for the file size which measures what fraction of the code is part of long files. The assessment is independent of findings being tolerated or not."));
    @ConfigExposed(name="File Size Assessment is SLOC-Based", description="Measure file size for file size assessment in SLOC instead of LOC.")
    private CodeScopeAware<Boolean> fileSizeAssessmentMetricSLOCBased = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    private final CodeScopeAware<FindingDescriptor> fileSizeFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Long File", EAnalysisTool.TEAMSCALE, StructuringConfiguration.getStructuringEnabledLanguages(), EFindingEnablement.AUTO, (String)CheckDescriptionLoader.getCheckDescription(StructuringConfiguration.class, (String)"cqse-file-size.md").orElseThrow(), Map.of("Value", "The actual value of the metric.")));
    @ConfigExposed(name="SLOC-Based", description="Measure method length in SLOC instead of LOC.")
    public CodeScopeAware<Boolean> methodLengthSLOCBased = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @ConfigExposed(name="Statements-Based", description="Measure method length by counting the number of Statements instead of LOC or SLOC.")
    private CodeScopeAware<Boolean> methodLengthNumberOfStatements = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Ignore Methods matching", description="Ignore methods whose names match the provided regex pattern.\nThe pattern must match the full method name.\nFor example, `^[A-Z].*` can be used to ignore methods starting with an uppercase letter.\n")
    private CodeScopeAware<String> ignoredMethodsPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @ConfigExposed(name="Method Length Thresholds", description="Thresholds for method length.")
    private CodeScopeAware<NumericThresholds> methodLengthThresholds = CodeScopeAware.defaultCodeScopeWithValue((Object)new NumericThresholds(30, 75));
    private final CodeScopeAware<MetricDescriptor> methodLengthMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Method Length", "The length of the longest method per file."));
    private final CodeScopeAware<MetricDescriptor> methodLengthAssessmentMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Method Length Assessment", "Assessment metric for the method length which measures what fraction of the code is part of long methods. The assessment is independent of findings being tolerated or not."));
    @ConfigExposed(name="Method Length Assessment is SLOC-Based", description="Measure size for method length assessment in SLOC instead of LOC.")
    private CodeScopeAware<Boolean> methodLengthAssessmentMetricSLOCBased = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @ConfigExposed(name="Method Length Assessment is Method-Based", description="Aggregate method length assessment by method instead of by file.")
    private CodeScopeAware<Boolean> methodLengthAssessmentMetricMethodBased = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    private final CodeScopeAware<FindingDescriptor> methodLengthFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Long Method", EAnalysisTool.TEAMSCALE, StructuringConfiguration.getStructuringEnabledLanguages(), EFindingEnablement.AUTO, (String)CheckDescriptionLoader.getCheckDescription(StructuringConfiguration.class, (String)"cqse-method-length.md").orElseThrow(), Map.of("Value", "The actual value of the metric.")));
    @ConfigExposed(name="Nesting Depth Thresholds", description="Thresholds for nesting depth.")
    private CodeScopeAware<NumericThresholds> nestingDepthThresholds = CodeScopeAware.defaultCodeScopeWithValue((Object)new NumericThresholds(3, 5));
    private final CodeScopeAware<MetricDescriptor> nestingDepthMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Nesting Depth", "The deepest nesting per file."));
    private final CodeScopeAware<MetricDescriptor> nestingDepthAssessmentMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Nesting Depth Assessment", "Assessment metric for the nesting depth which measures what fraction of the code is part of deeply nested methods. The assessment is independent of findings being tolerated or not."));
    @ConfigExposed(name="Nesting Depth Assessment is SLOC-Based", description="Measure size for nesting depth assessment in SLOC instead of LOC.")
    private CodeScopeAware<Boolean> nestingDepthAssessmentMetricSLOCBased = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @ConfigExposed(name="Nesting Depth Assessment is Method-Based", description="Aggregate nesting depth assessment by method instead of by file.")
    private CodeScopeAware<Boolean> nestingDepthAssessmentMetricMethodBased = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    private final CodeScopeAware<FindingDescriptor> nestingDepthFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Deep Nesting", EAnalysisTool.TEAMSCALE, StructuringConfiguration.getStructuringEnabledLanguages(), EFindingEnablement.AUTO, (String)CheckDescriptionLoader.getCheckDescription(StructuringConfiguration.class, (String)"cqse-nesting-depth.md").orElseThrow(), Map.of("Value", "The actual value of the metric.")));
    @ConfigExposed(name="Cyclomatic Complexity Thresholds", description="Thresholds for cyclomatic complexity.")
    private CodeScopeAware<NumericThresholds> complexityThresholds = CodeScopeAware.defaultCodeScopeWithValue((Object)new NumericThresholds(10, 20));
    private final CodeScopeAware<MetricDescriptor> complexityMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Cyclomatic Complexity", "The deepest cyclomatic complexity per file."));
    private final CodeScopeAware<MetricDescriptor> complexityAssessmentMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Cyclomatic Complexity Assessment", "Assessment for cyclomatic complexity per file."));
    @ConfigExposed(name="Cyclomatic Complexity Assessment is SLOC-Based", description="Measure size for cyclomatic complexity assessment in SLOC instead of LOC.")
    private CodeScopeAware<Boolean> complexityAssessmentMetricSLOCBased = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @ConfigExposed(name="Cyclomatic Complexity Assessment is Method-Based", description="Aggregate cyclomatic complexity assessment by method instead of by file.")
    private CodeScopeAware<Boolean> complexityAssessmentMetricMethodBased = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    private final CodeScopeAware<FindingDescriptor> complexityFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("High Cyclomatic Complexity", EAnalysisTool.TEAMSCALE, StructuringConfiguration.getStructuringEnabledLanguages(), EFindingEnablement.AUTO, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-complexity.md").orElseThrow(), Map.of("Value", "The actual value of the metric.")));
    @ConfigExposed(name="Findings Density", description="Enables metric for the findings density for this quality indicator.")
    public CodeScopeAware<Boolean> qualityIndicatorFindingsDensityMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Findings Density (Red)", description="Enables metric for the red findings density for this quality indicator.")
    public CodeScopeAware<Boolean> qualityIndicatorFindingsDensityRedMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Findings Density (Yellow)", description="Enables metric for the yellow findings density for this quality indicator.")
    public CodeScopeAware<Boolean> qualityIndicatorFindingsDensityYellowMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)false);

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.createStructuringMetrics(proxy.getCodeMetricSchema(), proxy.getCodeScopeNames());
        StructuringConfiguration.createLanguageMetric(proxy.getCodeMetricSchema());
        StructuringConfiguration.createCodeScopeMetric(proxy.getCodeMetricSchema());
        StructuringConfiguration.createFindingsDensityMetrics(proxy.getCodeMetricSchema());
        this.createTriggers(proxy);
        for (CodeScope codeScope : proxy.getCodeScopes()) {
            this.createFindingsSchemaEntries(proxy, codeScope.getName());
        }
    }

    private void createTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder metricsSynchronizer = new TriggerBuilder(StructuringAnalysis.class, ETriggerConcurrency.PARALLEL);
        metricsSynchronizer.setTriggerParameter("lsl-sloc-based", this.methodLengthSLOCBased);
        metricsSynchronizer.setTriggerParameter("lsl-statement-based", this.methodLengthNumberOfStatements);
        metricsSynchronizer.setTriggerParameter("ignored-methods-pattern", this.ignoredMethodsPattern);
        metricsSynchronizer.setTriggerParameter("lsl-assessment-sloc-based", this.methodLengthAssessmentMetricSLOCBased);
        metricsSynchronizer.setTriggerParameter("nesting-assessment-sloc-based", this.nestingDepthAssessmentMetricSLOCBased);
        metricsSynchronizer.setTriggerParameter("complexity-assessment-sloc-based", this.complexityAssessmentMetricSLOCBased);
        metricsSynchronizer.setMetricEnablementParameter("lsl-enabled", this.methodLengthMetric);
        metricsSynchronizer.setMetricEnablementParameter("nesting-depth-enabled", this.nestingDepthMetric);
        metricsSynchronizer.setMetricEnablementParameter("complexity-enabled", this.complexityAssessmentMetric);
        StructuringConfiguration.addThresholds(metricsSynchronizer, LINES_OF_CODE_METRIC, this.fileSizeThresholds);
        StructuringConfiguration.addThresholds(metricsSynchronizer, SOURCE_LINES_OF_CODE_METRIC, this.fileSizeThresholds);
        StructuringConfiguration.addThresholds(metricsSynchronizer, LONGEST_METHOD_LENGTH_METRIC, this.methodLengthThresholds);
        StructuringConfiguration.addThresholds(metricsSynchronizer, MAXIMUM_NESTING_DEPTH_METRIC, this.nestingDepthThresholds);
        StructuringConfiguration.addThresholds(metricsSynchronizer, MAXIMUM_CYCLOMATIC_COMPLEXITY_METRIC, this.complexityThresholds);
        metricsSynchronizer.setMetricEnablementParameter("lsl-assessment-enabled", this.methodLengthAssessmentMetric);
        metricsSynchronizer.setMetricEnablementParameter("nesting-depth-assessment-enabled", this.nestingDepthAssessmentMetric);
        metricsSynchronizer.setMetricEnablementParameter("complexity-assessment-enabled", this.complexityAssessmentMetric);
        proxy.createTrigger(metricsSynchronizer);
    }

    private static void addThresholds(TriggerBuilder metricsSynchronizer, String attributeNamePrefix, CodeScopeAware<NumericThresholds> thresholds) {
        metricsSynchronizer.setTriggerParameter(attributeNamePrefix + "-red-threshold", (ITriggerParameter)thresholds.map(NumericThresholds::getRedThreshold));
        metricsSynchronizer.setTriggerParameter(attributeNamePrefix + "-yellow-threshold", (ITriggerParameter)thresholds.map(NumericThresholds::getYellowThreshold));
    }

    private void createStructuringMetrics(MetricSchemaProxy schema, List<CodeScopeName> codeScopeNames) throws ProjectConfigurationException {
        schema.addMetric(FILES_METRIC, schema.createMetricIndexSource("elements"), FILES_METRIC_NAME, "Number of Files", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.SIZE_METRIC, EMetricProperty.QUALITY_NEUTRAL});
        StructuringConfiguration.createNumericMetric(LINES_OF_CODE_METRIC, LINES_OF_CODE_METRIC_NAME, schema, MetricDirectorySchemaEntry.EAggregation.SUM, StructuringConfiguration.containsOnlyTrue(this.disableLocMetrics), EMetricProperty.SIZE_METRIC, EMetricProperty.QUALITY_NEUTRAL);
        StructuringConfiguration.createNumericMetric(SOURCE_LINES_OF_CODE_METRIC, SOURCE_LINES_OF_CODE_METRIC_NAME, schema, MetricDirectorySchemaEntry.EAggregation.SUM, StructuringConfiguration.containsOnlyTrue(this.disableLocMetrics), EMetricProperty.SIZE_METRIC, EMetricProperty.QUALITY_NEUTRAL);
        StructuringConfiguration.createAssessmentMetric("file-size", this.determineFileSizeAssessmentValueMetricPerCodeScope(codeScopeNames), this.fileSizeAssessmentMetric, this.fileSizeThresholds, this.fileSizeAssessmentMetricSLOCBased, schema, CodeScopeUtils.isMetricEnabled(this.fileSizeAssessmentMetric), codeScopeNames);
        StructuringConfiguration.createNumericMetric(LONGEST_METHOD_LENGTH_METRIC, LONGEST_METHOD_LENGTH_METRIC_NAME, schema, MetricDirectorySchemaEntry.EAggregation.MAX, !CodeScopeUtils.isMetricEnabled(this.methodLengthMetric), new EMetricProperty[0]);
        StructuringConfiguration.createAssessmentMetricWithMethodAggregation(LONGEST_METHOD_LENGTH_METRIC, this.methodLengthAssessmentMetric, this.methodLengthThresholds, this.methodLengthAssessmentMetricSLOCBased, this.methodLengthAssessmentMetricMethodBased, METHOD_LENGTH_ASSESSMENT_PARTITION, schema, codeScopeNames);
        StructuringConfiguration.createNumericMetric(MAXIMUM_NESTING_DEPTH_METRIC, MAXIMUM_NESTING_DEPTH_METRIC_NAME, schema, MetricDirectorySchemaEntry.EAggregation.MAX, !CodeScopeUtils.isMetricEnabled(this.nestingDepthMetric), new EMetricProperty[0]);
        StructuringConfiguration.createAssessmentMetricWithMethodAggregation(MAXIMUM_NESTING_DEPTH_METRIC, this.nestingDepthAssessmentMetric, this.nestingDepthThresholds, this.nestingDepthAssessmentMetricSLOCBased, this.nestingDepthAssessmentMetricMethodBased, NESTING_DEPTH_ASSESSMENT_PARTITION, schema, codeScopeNames);
        StructuringConfiguration.createNumericMetric(MAXIMUM_CYCLOMATIC_COMPLEXITY_METRIC, MAXIMUM_CYCLOMATIC_COMPLEXITY_METRIC_NAME, schema, MetricDirectorySchemaEntry.EAggregation.MAX, !CodeScopeUtils.isMetricEnabled(this.complexityMetric), new EMetricProperty[0]);
        StructuringConfiguration.createAssessmentMetricWithMethodAggregation(MAXIMUM_CYCLOMATIC_COMPLEXITY_METRIC, this.complexityAssessmentMetric, this.complexityThresholds, this.complexityAssessmentMetricSLOCBased, this.complexityAssessmentMetricMethodBased, COMPLEXITY_ASSESSMENT_PARTITION, schema, codeScopeNames);
    }

    private static boolean containsOnlyTrue(CodeScopeAware<Boolean> disablementPerCodeScope) {
        return !StructuringConfiguration.contains(disablementPerCodeScope, Boolean.FALSE);
    }

    private static boolean contains(CodeScopeAware<Boolean> values, Boolean searchValue) {
        if (values.getValues().isEmpty()) {
            return false;
        }
        return values.getValues().contains(searchValue);
    }

    private @NonNull CodeScopeAware<String> determineFileSizeAssessmentValueMetricPerCodeScope(List<CodeScopeName> codeScopeNames) {
        CodeScopeAware fileSizeAssessmentValueMetricPerCodeScope = CodeScopeAware.empty();
        codeScopeNames.forEach(codeScopeName -> {
            if (((Boolean)this.fileSizeAssessmentMetricSLOCBased.getValueWithDefault(codeScopeName)).booleanValue()) {
                fileSizeAssessmentValueMetricPerCodeScope.setValue(codeScopeName, (Object)SOURCE_LINES_OF_CODE_METRIC);
            } else {
                fileSizeAssessmentValueMetricPerCodeScope.setValue(codeScopeName, (Object)LINES_OF_CODE_METRIC);
            }
        });
        return fileSizeAssessmentValueMetricPerCodeScope;
    }

    private static void createLanguageMetric(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric(LANGUAGE_METRIC, schema.createMetricIndexSource(LANGUAGE_METRIC), LANGUAGE_METRIC_NAME, "Mapped Language of File", EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
    }

    private static void createCodeScopeMetric(MetricSchemaProxy schema) throws ProjectConfigurationException {
        String displayDescription = "The Code Scope(s) a file or folder is mapped to";
        schema.addMetric(CODE_SCOPE_METRIC, schema.createMetricIndexSource(CODE_SCOPE_METRIC), "Code Scope", displayDescription, EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
    }

    private static void createAssessmentMetricWithMethodAggregation(String valueMetric, CodeScopeAware<MetricDescriptor> assessmentMetric, CodeScopeAware<NumericThresholds> thresholds, CodeScopeAware<Boolean> sizeIsSLOCBased, CodeScopeAware<Boolean> useMethodBasedMetric, String methodBasedMetricName, MetricSchemaProxy schema, List<CodeScopeName> codeScopeNames) throws ProjectConfigurationException {
        boolean metricEnabled = CodeScopeUtils.isMetricEnabled(assessmentMetric);
        if (metricEnabled && StructuringConfiguration.contains(useMethodBasedMetric, Boolean.TRUE)) {
            schema.addMetric(valueMetric + "-assessment", schema.createMetricIndexSource(methodBasedMetricName), ((MetricDescriptor)assessmentMetric.getValueForDefaultCodeScope()).getName(), ((MetricDescriptor)assessmentMetric.getValueForDefaultCodeScope()).getDescription(), EMetricValueType.ASSESSMENT, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
        } else {
            CodeScopeAware valueMetricPerCodeScope = CodeScopeAware.empty();
            codeScopeNames.forEach(codeScopeName -> valueMetricPerCodeScope.setValue(codeScopeName, (Object)valueMetric));
            StructuringConfiguration.createAssessmentMetric(valueMetric, (CodeScopeAware<String>)valueMetricPerCodeScope, assessmentMetric, thresholds, sizeIsSLOCBased, schema, metricEnabled, codeScopeNames);
        }
    }

    private static void createAssessmentMetric(String metricName, CodeScopeAware<String> valueMetric, CodeScopeAware<MetricDescriptor> assessmentMetric, CodeScopeAware<NumericThresholds> thresholds, CodeScopeAware<Boolean> sizeIsSLOCBased, MetricSchemaProxy schema, boolean metricEnabled, List<CodeScopeName> codeScopeNames) throws ProjectConfigurationException {
        if (!metricEnabled) {
            return;
        }
        CodeScopeAware assessmentRangesPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware sizeMetricPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : codeScopeNames) {
            List<AssessedRange> assessmentRanges = List.of(new AssessedRange(-1.0, (double)((NumericThresholds)thresholds.getValueWithDefault(codeScopeName)).getYellowThreshold(), ETrafficLightColor.GREEN), new AssessedRange((double)((NumericThresholds)thresholds.getValueWithDefault(codeScopeName)).getYellowThreshold(), (double)((NumericThresholds)thresholds.getValueWithDefault(codeScopeName)).getRedThreshold(), ETrafficLightColor.YELLOW));
            assessmentRangesPerCodeScope.setValue(codeScopeName, assessmentRanges);
            if (((Boolean)sizeIsSLOCBased.getValueWithDefault(codeScopeName)).booleanValue()) {
                sizeMetricPerCodeScope.setValue(codeScopeName, (Object)SOURCE_LINES_OF_CODE_METRIC);
                continue;
            }
            sizeMetricPerCodeScope.setValue(codeScopeName, (Object)LINES_OF_CODE_METRIC);
        }
        schema.addMetric(metricName + "-assessment", schema.createAssessmentMetricSource(valueMetric, sizeMetricPerCodeScope, assessmentRangesPerCodeScope, CodeScopeUtils.getCodeScopesWithDisabledMetric(assessmentMetric)), ((MetricDescriptor)assessmentMetric.getValueForDefaultCodeScope()).getName(), ((MetricDescriptor)assessmentMetric.getValueForDefaultCodeScope()).getDescription(), EMetricValueType.ASSESSMENT, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
    }

    private static void createNumericMetric(String name, String displayName, MetricSchemaProxy schema, MetricDirectorySchemaEntry.EAggregation aggregation, boolean hideMetric, EMetricProperty ... properties) throws ProjectConfigurationException {
        if (hideMetric) {
            properties = Arrays.copyOf(properties, properties.length + 1);
            properties[properties.length - 1] = EMetricProperty.HIDDEN;
        }
        schema.addMetric(name, schema.createMetricIndexSource(name), displayName, displayName, EMetricValueType.NUMERIC, aggregation, properties);
    }

    private void createFindingsSchemaEntries(ProjectCreationProxy proxy, CodeScopeName codeScopeName) {
        String fileSizeFindingsGroup = "LoC";
        if (((Boolean)this.fileSizeSLOCBased.getValueWithDefault(codeScopeName)).booleanValue()) {
            fileSizeFindingsGroup = "SLOC";
        }
        proxy.addFindingsSchemaEntry(METRIC_VIOLATIONS_FINDINGS_CATEGORY, fileSizeFindingsGroup, (FindingDescriptor)this.fileSizeFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry(METHOD_LENGTH_TYPE_ID, (FindingDescriptor)this.methodLengthFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry(NESTING_DEPTH_TYPE_ID, (FindingDescriptor)this.nestingDepthFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry(COMPLEXITY_TYPE_ID, (FindingDescriptor)this.complexityFinding.getValue(codeScopeName), codeScopeName);
    }

    private static void createFindingsDensityMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        FindingsDensityMetric.FINDINGS_DENSITY.registerInSchema(schema);
        FindingsDensityMetric.FINDINGS_DENSITY_RED.registerInSchema(schema);
        FindingsDensityMetric.FINDINGS_DENSITY_YELLOW.registerInSchema(schema);
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        CodeScopeName codeScopeName = template.getCodeScope();
        this.autoExpose(codeScopeName);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        if (IndexBasedAnalysisConstants.containsFindingsDensityLanguage(languages)) {
            this.registerFindingsDensities(template, codeScopeName);
        }
        if (IndexBasedAnalysisConstants.allLanguagesHaveStructuringAndCloningDisabled(languages)) {
            return;
        }
        if (IndexBasedAnalysisConstants.containsCodeLanguage(languages)) {
            if (languages.size() == 1 && languages.contains(ELanguage.COBOL)) {
                ((NumericThresholds)this.methodLengthThresholds.getValue(codeScopeName)).multiply(2);
                ((NumericThresholds)this.fileSizeThresholds.getValue(codeScopeName)).multiply(2);
            }
            this.registerFileSize(template, codeScopeName);
            this.registerMethodLength(template, codeScopeName);
            this.registerNestingDepth(template, codeScopeName);
            this.registerCyclomaticComplexity(template, codeScopeName);
        } else {
            template.registerGlobalOptionCodeScopeAware(this.getOptionForField("disableLocMetrics", codeScopeName));
        }
    }

    private void registerFindingsDensities(ConfigurationTemplate template, CodeScopeName codeScopeName) {
        template.registerQualityIndicatorOption(this.getOptionForField("qualityIndicatorFindingsDensityMetric", codeScopeName));
        template.registerQualityIndicatorOption(this.getOptionForField("qualityIndicatorFindingsDensityRedMetric", codeScopeName));
        template.registerQualityIndicatorOption(this.getOptionForField("qualityIndicatorFindingsDensityYellowMetric", codeScopeName));
    }

    private void registerFileSize(ConfigurationTemplate template, CodeScopeName codeScopeName) {
        template.registerConfigurationItemsCodeScopeAware("File Size", "Structure", List.of((ConfigurationItemBase)this.fileSizeAssessmentMetric.getValue(codeScopeName), this.getOptionForField("fileSizeAssessmentMetricSLOCBased", codeScopeName), this.getOptionForField("fileSizeThresholds", codeScopeName), (ConfigurationItemBase)this.fileSizeFinding.getValue(codeScopeName), this.getOptionForField("fileSizeSLOCBased", codeScopeName)));
    }

    private void registerMethodLength(ConfigurationTemplate template, CodeScopeName codeScopeName) {
        template.registerConfigurationItemsCodeScopeAware("Method Length", "Structure", List.of((ConfigurationItemBase)this.methodLengthMetric.getValue(codeScopeName), (ConfigurationItemBase)this.methodLengthAssessmentMetric.getValue(codeScopeName)));
        template.registerConfigurationItemsCodeScopeAware("Method Length", "Structure", List.of(this.getOptionForField("methodLengthAssessmentMetricMethodBased", codeScopeName)));
        template.registerConfigurationItemsCodeScopeAware("Method Length", "Structure", List.of(this.getOptionForField("methodLengthAssessmentMetricSLOCBased", codeScopeName), this.getOptionForField("methodLengthThresholds", codeScopeName), (ConfigurationItemBase)this.methodLengthFinding.getValue(codeScopeName), this.getOptionForField("methodLengthSLOCBased", codeScopeName), this.getOptionForField("methodLengthNumberOfStatements", codeScopeName), this.getOptionForField("ignoredMethodsPattern", codeScopeName)));
    }

    private void registerNestingDepth(ConfigurationTemplate template, CodeScopeName codeScopeName) {
        template.registerConfigurationItemsCodeScopeAware(NESTING_DEPTH_FINDING_GROUP, "Structure", List.of((ConfigurationItemBase)this.nestingDepthMetric.getValue(codeScopeName), (ConfigurationItemBase)this.nestingDepthAssessmentMetric.getValue(codeScopeName), this.getOptionForField("nestingDepthAssessmentMetricMethodBased", codeScopeName), this.getOptionForField("nestingDepthAssessmentMetricSLOCBased", codeScopeName), this.getOptionForField("nestingDepthThresholds", codeScopeName), (ConfigurationItemBase)this.nestingDepthFinding.getValue(codeScopeName)));
    }

    private void registerCyclomaticComplexity(ConfigurationTemplate template, CodeScopeName codeScopeName) {
        template.registerConfigurationItemsCodeScopeAware(CYCLOMATIC_COMPLEXITY_FINDING_GROUP, null, List.of((ConfigurationItemBase)this.complexityMetric.getValue(codeScopeName), (ConfigurationItemBase)this.complexityAssessmentMetric.getValue(codeScopeName)));
        template.registerConfigurationItemsCodeScopeAware(CYCLOMATIC_COMPLEXITY_FINDING_GROUP, null, List.of(this.getOptionForField("complexityAssessmentMetricMethodBased", codeScopeName)));
        template.registerConfigurationItemsCodeScopeAware(CYCLOMATIC_COMPLEXITY_FINDING_GROUP, null, List.of(this.getOptionForField("complexityAssessmentMetricSLOCBased", codeScopeName), this.getOptionForField("complexityThresholds", codeScopeName), (ConfigurationItemBase)this.complexityFinding.getValue(codeScopeName)));
    }

    public void applyQualityIndicatorOptions(String qualityIndicatorName, ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.addFindingsDensityMetricsForCategory(qualityIndicatorName, proxy.getCodeMetricSchema());
    }

    private void addFindingsDensityMetricsForCategory(String category, MetricSchemaProxy schema) throws ProjectConfigurationException {
        if (StructuringConfiguration.contains(this.qualityIndicatorFindingsDensityMetric, Boolean.TRUE)) {
            StructuringConfiguration.addFindingsDensityMetricForCategory(category, EFindingsMetricCategory.ALL, schema);
        }
        if (StructuringConfiguration.contains(this.qualityIndicatorFindingsDensityRedMetric, Boolean.TRUE)) {
            StructuringConfiguration.addFindingsDensityMetricForCategory(category, EFindingsMetricCategory.RED, schema);
        }
        if (StructuringConfiguration.contains(this.qualityIndicatorFindingsDensityYellowMetric, Boolean.TRUE)) {
            StructuringConfiguration.addFindingsDensityMetricForCategory(category, EFindingsMetricCategory.YELLOW, schema);
        }
    }

    private static void addFindingsDensityMetricForCategory(String category, EFindingsMetricCategory color, MetricSchemaProxy schema) throws ProjectConfigurationException {
        CoreConfiguration.addFindingsCountByCategoryToSchema((MetricSchemaProxy)schema, (String)category, (boolean)true, (EFindingsMetricCategory)color);
        FindingsDensityForSingleCategoryMetric metric = new FindingsDensityForSingleCategoryMetric(color.getFindingsSummaryMetric().createFindingsCountMetricForCategory(category, false));
        if (!schema.hasMetric(metric.getRawId())) {
            metric.registerInSchema(schema);
        }
    }

    private static @NonNull Set<ELanguage> getStructuringEnabledLanguages() {
        return CollectionUtils.differenceSet(EnumSet.allOf(ELanguage.class), (Collection[])new Collection[]{Set.of(ELanguage.KUBERNETES)});
    }
}

