/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.configuration.ETaintAnalysisOptions;
import com.teamscale.index.dataflow.taintpropagation.MethodTaintGraphBarrierIndex;
import com.teamscale.index.dataflow.taintpropagation.MethodTaintGraphGenerationAnalysisRunner;
import com.teamscale.index.dataflow.taintpropagation.TaintAnalysisRunner;
import com.teamscale.index.dataflow.taintpropagation.methodindex.EnrichedMethodTaintGraphIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodCallIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodCallIndexSynchronizer;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodIndexSynchronizer;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodTaintGraphIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.ETaintSinkType;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class TaintAnalysisConfiguration
extends AnalysisConfigurationBase {
    private static final EnumSet<ELanguage> SUPPORTED_LANGUAGES = EnumSet.of(ELanguage.ABAP);
    private final List<ConfigurationItemBase> taintAnalysisGroupItems = new ArrayList<ConfigurationItemBase>();
    private final List<ConfigurationItemBase> taintGraphGenerationGroupItems = new ArrayList<ConfigurationItemBase>();
    private final List<FindingDescriptor> taintFindingDescriptors = new ArrayList<FindingDescriptor>();
    @ConfigExposed(name="Support sideeffects on unused fields", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL, description="If this option is disabled, the analysis will track field changes done by called methods only if\tthe respective field is\treferenced in the current method.")
    private boolean supportSideeffectsOnUnusedFields = false;
    @ConfigExposed(name="Store partial graph on abort", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL, description="If this option is enabled, we will store a (partial) method taint graph even if the generation is aborted (e.g., due to timeout).")
    private boolean storePartialGraphOnAbort = false;
    @ConfigExposed(name="Assume that unknown methods clear taints", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL, description="Assume that methods for which we don't have implementations do not propagate taints.")
    private boolean assumeUnknownMethodsClearTaints = false;
    @ConfigExposed(name="Ignore calls to SAP library methods", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL, description="Assume that calls to SAP library methods don't propagate taints and that we never have their implementation.")
    private boolean ignoreCallsToSapLibrary = true;
    @ConfigExposed(name="Treat parameters (except EXPORTING) of function modules that can be called via RFC as potential taint sources", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL, description="Whether we should treat parameters of function modules that can be called via RFC as potential taint sources. This applies to all parameters except EXPORTING parameters. There is another configuration option for EXPORTING. This can have a big impact on the analysis performance.")
    private boolean treatParametersOfRfcEnabledFunctionModulesAsTaintSource = true;
    @ConfigExposed(name="Treat EXPORTING parameters of function modules that can be called via RFC as potential taint sources", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL, description="Whether we should treat parameters (with EXPORTING modifier) of function modules that can be called via RFC as potential taint sources. This can have a big impact on the analysis performance.")
    private boolean treatExportingParametersOfRfcEnabledFunctionModulesAsTaintSource = true;
    @ConfigExposed(name="Sanitizer functions", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="List of ant patterns describing sanitizer function names (functions that clear tainted input variables).  Each line contains a pattern. If a line starts with a sink-type name and a colon, the sanitizer only applies to this sink type (e.g, \"SQL_INJECTION: escapeSQL\").")
    public List<String> sanitizerPatterns = Arrays.asList("FILENAME: FILE_GET_NAME", "FILENAME: file_get_name_and_validate", "FILENAME: FILE_GET_NAME_AND_LOGICAL_PATH", "FILENAME: FILE_VALIDATE_NAME");
    @ConfigExposed(name="Max. number of paths between statements", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL, description="Config parameter for the maximum number of paths considered between two statements.")
    private int maxPathsBetweenStatements = 5;
    public final EnumSet<ETaintAnalysisOptions> configurationOptions = EnumSet.noneOf(ETaintAnalysisOptions.class);

    public TaintAnalysisConfiguration() {
        this.autoExpose();
        this.registerGlobalOptions();
        for (ETaintSinkType sinkType : ETaintSinkType.values()) {
            FindingDescriptor descriptor = new FindingDescriptor(TaintAnalysisConfiguration.getFindingGroupName(sinkType), StringUtils.escapeMarkdownChars((String)TaintAnalysisConfiguration.getFindingGroupName(sinkType)), EAnalysisTool.TEAMSCALE, SUPPORTED_LANGUAGES, EFindingEnablement.RED, sinkType.getFindingDescription());
            this.taintFindingDescriptors.add(descriptor);
            this.taintAnalysisGroupItems.add((ConfigurationItemBase)descriptor);
            this.addFindingDescriptor(descriptor);
        }
        FindingDescriptor descriptor = new FindingDescriptor("Taint Graph Generation", EAnalysisTool.TEAMSCALE, SUPPORTED_LANGUAGES, EFindingEnablement.YELLOW, "Taint Graph could not be generated.");
        this.taintFindingDescriptors.add(descriptor);
        this.taintGraphGenerationGroupItems.add((ConfigurationItemBase)descriptor);
        this.addFindingDescriptor(descriptor);
        this.processConfigurationOptions();
    }

    private void registerGlobalOptions() {
        if (!this.taintAnalysisGroupItems.isEmpty()) {
            throw new IllegalStateException("Global options must be registered first");
        }
        this.taintAnalysisGroupItems.add((ConfigurationItemBase)this.getOptionForField("supportSideeffectsOnUnusedFields"));
        this.taintAnalysisGroupItems.add((ConfigurationItemBase)this.getOptionForField("storePartialGraphOnAbort"));
        this.taintAnalysisGroupItems.add((ConfigurationItemBase)this.getOptionForField("assumeUnknownMethodsClearTaints"));
        this.taintAnalysisGroupItems.add((ConfigurationItemBase)this.getOptionForField("ignoreCallsToSapLibrary"));
        this.taintAnalysisGroupItems.add((ConfigurationItemBase)this.getOptionForField("sanitizerPatterns"));
        this.taintAnalysisGroupItems.add((ConfigurationItemBase)this.getOptionForField("maxPathsBetweenStatements"));
    }

    public static String getFindingGroupName(ETaintSinkType sinkType) {
        return "Taint Propagation - " + sinkType.toString();
    }

    private static List<String> toStringList(Collection<?> input) {
        return input.stream().map(Object::toString).collect(Collectors.toList());
    }

    private void processConfigurationOptions() {
        if (this.supportSideeffectsOnUnusedFields) {
            this.configurationOptions.add(ETaintAnalysisOptions.SUPPORT_SIDEEFFECTS_ON_UNUSED_FIELDS);
        }
        if (this.storePartialGraphOnAbort) {
            this.configurationOptions.add(ETaintAnalysisOptions.STORE_PARTIAL_GRAPH_ON_ABORT);
        }
        if (this.assumeUnknownMethodsClearTaints) {
            this.configurationOptions.add(ETaintAnalysisOptions.ASSUME_UNKNOWN_METHODS_CLEAR_TAINTS);
        }
        if (this.ignoreCallsToSapLibrary) {
            this.configurationOptions.add(ETaintAnalysisOptions.IGNORE_CALLS_TO_SAP_LIBRARY);
        }
        if (this.treatParametersOfRfcEnabledFunctionModulesAsTaintSource) {
            this.configurationOptions.add(ETaintAnalysisOptions.TREAT_PARAMETERS_OF_RFC_ENABLED_FUNCTION_MODULES_AS_TAINT_SOURCE);
        }
        if (this.treatExportingParametersOfRfcEnabledFunctionModulesAsTaintSource) {
            this.configurationOptions.add(ETaintAnalysisOptions.TREAT_EXPORTING_PARAMETERS_OF_RFC_ENABLED_FUNCTION_MODULES_AS_TAINT_SOURCE);
        }
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (CollectionUtils.intersectionSet(languages, (Collection[])new Collection[]{SUPPORTED_LANGUAGES}).isEmpty()) {
            return;
        }
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerConfigurationItems("Taint Propagation", null, this.taintAnalysisGroupItems);
        template.registerConfigurationItems("Taint Graph Generation", null, this.taintGraphGenerationGroupItems);
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        Set enabledDescriptors = this.taintFindingDescriptors.stream().filter(descriptor -> descriptor.getEnablement().isEnabled()).collect(Collectors.toSet());
        if (enabledDescriptors.isEmpty()) {
            return;
        }
        for (FindingDescriptor descriptor2 : enabledDescriptors) {
            proxy.addFindingsSchemaEntry("Dataflow", descriptor2.getName(), descriptor2);
        }
        this.processConfigurationOptions();
        TaintAnalysisConfiguration.createIndices(proxy);
        this.createTriggers(proxy);
    }

    private static void createIndices(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(MethodIndex.class);
        proxy.createProjectIndex(MethodCallIndex.class);
        proxy.createProjectIndex(MethodTaintGraphIndex.class);
        proxy.createProjectIndex(EnrichedMethodTaintGraphIndex.class);
        proxy.createProjectIndex(MethodTaintGraphBarrierIndex.class);
    }

    private void createTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(new TriggerBuilder(MethodIndexSynchronizer.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(MethodCallIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        TriggerBuilder taintGraphSynchronizerTriggerBuilder = new TriggerBuilder(MethodTaintGraphGenerationAnalysisRunner.class, ETriggerConcurrency.PARALLEL);
        taintGraphSynchronizerTriggerBuilder.setTriggerParameter("taint-analysis-options", ITriggerParameter.of(ETaintAnalysisOptions.filterOptionsFor(MethodTaintGraphGenerationAnalysisRunner.class, this.configurationOptions)));
        proxy.createTrigger(taintGraphSynchronizerTriggerBuilder);
        TriggerBuilder taintFindingsSynchronizerTriggerBuilder = new TriggerBuilder(TaintAnalysisRunner.class, ETriggerConcurrency.PARALLEL);
        taintFindingsSynchronizerTriggerBuilder.setTriggerParameter("taint-analysis-options", ITriggerParameter.of(TaintAnalysisConfiguration.toStringList(ETaintAnalysisOptions.filterOptionsFor(TaintAnalysisRunner.class, this.configurationOptions))));
        taintFindingsSynchronizerTriggerBuilder.setTriggerParameter("sanitizer-patterns", ITriggerParameter.of(this.sanitizerPatterns));
        taintFindingsSynchronizerTriggerBuilder.setTriggerParameter("path-limit", this.maxPathsBetweenStatements);
        proxy.createTrigger(taintFindingsSynchronizerTriggerBuilder);
    }

    public int getMaxPathsBetweenStatements() {
        return this.maxPathsBetweenStatements;
    }
}

