/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.findings.dart_lint.DartLintSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.error.FormatException;

public class DartLintConfiguration
extends ToolConfigurationBase {
    public static final String FINDING_CATEGORY = "DartLint";
    public static final String CHECK_MAPPINGS_TSV = "check-mappings.tsv";
    public static final String DIAGNOSTIC_MESSAGES_MAPPING_TSV = "diagnostic_messages.tsv";
    private static final String DESCRIPTIONS_ROOT_DIR = "dart-lint";

    public DartLintConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.DART_LINT, FINDING_CATEGORY, DESCRIPTIONS_ROOT_DIR, "dart-lint/check-mappings.tsv", null, "");
        this.declareCodeScopeAware();
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        return this.getGroupToQualityIndicator(codeScopeName).getOrDefault(groupName, "Uncategorized Dart Check");
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        TriggerBuilder triggerBuilder = new TriggerBuilder(DartLintSynchronizer.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setTriggerParameter("checks", (ITriggerParameter)activeChecksPerCodeScope);
        proxy.createTrigger(triggerBuilder);
        super.configureProject(proxy);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        if (!tools.contains(this.tool)) {
            return;
        }
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }

    public void validateTools() throws ProjectConfigurationException {
        try {
            DartLintSynchronizer.verifyVersion();
        }
        catch (ProjectConfigurationException | IOException | FormatException e) {
            throw new ProjectConfigurationException("Dart SDK version validation failed", e);
        }
    }
}

