/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.findings.raex.RaexFindingsSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.lib.commons.io.DotNetUtils;

public abstract class RaexConfigurationBase
extends ToolConfigurationBase {
    public static final String CATEGORY_NAME = "RA\u00cbX";
    private static final String DESCRIPTION_BASE_PATH = "raex";

    protected RaexConfigurationBase(EAnalysisTool tool, String categoryName, String descriptionPath, String mappingsFile) throws ProjectConfigurationException {
        super(tool, categoryName, "raex/" + descriptionPath, mappingsFile, "");
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder triggerBuilder = new TriggerBuilder(RaexFindingsSynchronizer.class, ETriggerConcurrency.PARALLEL);
        if (!proxy.isTriggerAlreadyCreated(triggerBuilder.getSimpleTriggerName())) {
            proxy.createTrigger(triggerBuilder);
        }
        super.configureProject(proxy);
    }

    public void validateTools() throws ProjectConfigurationException {
        RaexConfigurationBase.ensureDotnetIsInstalled();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        super.registerQualityIndicators(template, languages, tools);
    }

    private static void ensureDotnetIsInstalled() throws ProjectConfigurationException {
        String dotnetInstallationStatus = DotNetUtils.checkDotnetIsInstalled();
        if (dotnetInstallationStatus != null) {
            throw new ProjectConfigurationException(dotnetInstallationStatus);
        }
    }

    protected Set<ELanguage> determineLanguages(String ruleId) {
        return Set.of(ELanguage.CS);
    }
}

